/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.backup;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.backup.FileReplication;
import com.aoindustries.aoserv.client.backup.MysqlReplication;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class MysqlReplicationTable
extends CachedTableIntegerKey<MysqlReplication> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("mysql_server.ao_server.hostname", true), new AoservTable.OrderBy("mysql_server.name", true), new AoservTable.OrderBy("ao_server", true), new AoservTable.OrderBy("replication", true)};

    MysqlReplicationTable(AoservConnector connector) {
        super(connector, MysqlReplication.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public MysqlReplication get(int pkey) throws IOException, SQLException {
        return (MysqlReplication)this.getUniqueRow(0, pkey);
    }

    public List<MysqlReplication> getFailoverMysqlReplications(Package pk) throws IOException, SQLException {
        ArrayList<MysqlReplication> matches = new ArrayList<MysqlReplication>();
        for (Bind nb : pk.getNetBinds()) {
            Server ms = nb.getMysqlServer();
            if (ms == null) continue;
            matches.addAll(ms.getFailoverMysqlReplications());
        }
        return matches;
    }

    public List<MysqlReplication> getFailoverMysqlReplications(Server mysqlServer) throws IOException, SQLException {
        return this.getIndexedRows(3, mysqlServer.getPkey());
    }

    public List<MysqlReplication> getFailoverMysqlReplications(com.aoindustries.aoserv.client.linux.Server aoServer) throws IOException, SQLException {
        return this.getIndexedRows(1, aoServer.getPkey());
    }

    List<MysqlReplication> getFailoverMysqlReplications(FileReplication replication) throws IOException, SQLException {
        return this.getIndexedRows(2, replication.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.FAILOVER_MYSQL_REPLICATIONS;
    }
}

