/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.i18n.ThreadLocale;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Currency
extends GlobalObjectStringKey<Currency> {
    static final int COLUMN_currencyCode = 0;
    static final String COLUMN_currencyCode_name = "currencyCode";
    public static final java.util.Currency USD = java.util.Currency.getInstance("USD");
    private short fractionDigits;
    private Money autoEnableMinimumPayment;

    @Deprecated
    public Currency() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.fractionDigits;
            }
            case 2: {
                return this.autoEnableMinimumPayment;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getCurrencyCode() {
        return this.pkey;
    }

    public java.util.Currency getCurrency() {
        return this.autoEnableMinimumPayment.getCurrency();
    }

    public short getFractionDigits() {
        assert (this.getCurrency().getDefaultFractionDigits() == this.fractionDigits);
        return this.fractionDigits;
    }

    public Money getAutoEnableMinimumPayment() {
        return this.autoEnableMinimumPayment;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.Currency;
    }

    @Override
    public void init(ResultSet results) throws SQLException {
        this.pkey = results.getString(COLUMN_currencyCode_name);
        this.fractionDigits = results.getShort("fractionDigits");
        this.autoEnableMinimumPayment = new Money(java.util.Currency.getInstance(this.pkey), results.getBigDecimal("autoEnableMinimumPayment"));
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.fractionDigits = in.readShort();
        this.autoEnableMinimumPayment = new Money(java.util.Currency.getInstance(this.pkey), in.readLong(), in.readCompressedInt());
    }

    @Override
    public String toStringImpl() {
        return this.getCurrency().getDisplayName(ThreadLocale.get());
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeShort((int)this.fractionDigits);
        out.writeLong(this.autoEnableMinimumPayment.getUnscaledValue());
        out.writeCompressedInt(this.autoEnableMinimumPayment.getScale());
    }
}

