/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.dto.Money;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Currency;

public final class MoneyUtil {
    private MoneyUtil() {
        throw new AssertionError();
    }

    public static Money getDto(com.aoapps.lang.i18n.Money money) {
        return money == null ? null : new Money(money.getCurrency().getCurrencyCode(), money.getValue());
    }

    public static com.aoapps.lang.i18n.Money getMoney(Money money) {
        if (money == null) {
            return null;
        }
        return new com.aoapps.lang.i18n.Money(Currency.getInstance(money.getCurrency()), money.getValue());
    }

    public static com.aoapps.lang.i18n.Money getMoney(Currency currency, BigDecimal value) {
        if (value == null) {
            return null;
        }
        return new com.aoapps.lang.i18n.Money(currency, value);
    }

    public static com.aoapps.lang.i18n.Money getMoney(ResultSet result, String currencyColumnLabel, String valueColumnLabel) throws SQLException {
        BigDecimal value = result.getBigDecimal(valueColumnLabel);
        if (value == null) {
            return null;
        }
        String currencyCode = result.getString(currencyColumnLabel);
        if (currencyCode == null) {
            throw new SQLException(currencyColumnLabel + " == null && " + valueColumnLabel + " != null");
        }
        return new com.aoapps.lang.i18n.Money(Currency.getInstance(currencyCode), value);
    }

    public static void writeMoney(com.aoapps.lang.i18n.Money money, StreamableOutput out) throws IOException {
        out.writeUTF(money.getCurrency().getCurrencyCode());
        out.writeLong(money.getUnscaledValue());
        out.writeCompressedInt(money.getScale());
    }

    public static void writeNullMoney(com.aoapps.lang.i18n.Money money, StreamableOutput out) throws IOException {
        if (money != null) {
            out.writeBoolean(true);
            MoneyUtil.writeMoney(money, out);
        } else {
            out.writeBoolean(false);
        }
    }

    public static com.aoapps.lang.i18n.Money readMoney(StreamableInput in) throws IOException {
        return new com.aoapps.lang.i18n.Money(Currency.getInstance(in.readUTF()), in.readLong(), in.readCompressedInt());
    }

    public static com.aoapps.lang.i18n.Money readNullMoney(StreamableInput in) throws IOException {
        return in.readBoolean() ? MoneyUtil.readMoney(in) : null;
    }
}

