/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.math.SafeMath;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.SQLUtility;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.billing.Currency;
import com.aoindustries.aoserv.client.billing.MoneyUtil;
import com.aoindustries.aoserv.client.billing.MonthlyChargeTable;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class MonthlyCharge
extends CachedObjectIntegerKey<MonthlyCharge> {
    static final int COLUMN_PKEY = 0;
    static final String COLUMN_PKEY_name = "pkey";
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_PACKAGE_name = "package";
    static final String COLUMN_TYPE_name = "type";
    static final String COLUMN_CREATED_name = "created";
    private Account.Name accounting;
    private Account.Name packageName;
    private String type;
    private String description;
    private int quantity;
    private Money rate;
    private UnmodifiableTimestamp created;
    private User.Name createdBy;
    private boolean active;

    @Deprecated
    public MonthlyCharge() {
    }

    MonthlyCharge(MonthlyChargeTable table, Account business, Package packageObject, TransactionType typeObject, String description, int quantity, Money rate, Administrator createdByObject, boolean active) {
        this.setTable(table);
        this.pkey = -1;
        this.accounting = business.getName();
        this.packageName = packageObject.getName();
        this.type = typeObject.getName();
        this.description = description;
        this.quantity = quantity;
        this.rate = rate;
        this.created = new UnmodifiableTimestamp(System.currentTimeMillis());
        this.createdBy = createdByObject.getUsername_userId();
        this.active = active;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey == -1 ? null : Integer.valueOf(this.pkey);
            }
            case 1: {
                return this.accounting;
            }
            case 2: {
                return this.packageName;
            }
            case 3: {
                return this.type;
            }
            case 4: {
                return this.description;
            }
            case 5: {
                return this.quantity;
            }
            case 6: {
                return this.rate;
            }
            case 7: {
                return this.created;
            }
            case 8: {
                return this.createdBy;
            }
            case 9: {
                return this.active;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public Administrator getCreatedBy() throws SQLException, IOException {
        Administrator obj = this.table.getConnector().getAccount().getAdministrator().get(this.createdBy);
        if (obj == null) {
            throw new SQLException("Unable to find Administrator: " + this.createdBy);
        }
        return obj;
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return obj;
    }

    public String getDescription() throws SQLException, IOException {
        return this.description == null ? this.getType().getDescription() : this.description;
    }

    public Package getPackage() throws SQLException, IOException {
        Package packageObject = this.table.getConnector().getBilling().getPackage().get(this.packageName);
        if (packageObject == null) {
            throw new SQLException("Unable to find Package: " + this.packageName);
        }
        return packageObject;
    }

    public Money getAmount() {
        return this.rate == null ? null : this.rate.multiply(BigDecimal.valueOf(this.quantity, 3), RoundingMode.HALF_UP);
    }

    public int getQuantity() {
        return this.quantity;
    }

    public Money getRate() {
        return this.rate;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MONTHLY_CHARGES;
    }

    public TransactionType getType() throws SQLException, IOException {
        TransactionType typeObject = this.table.getConnector().getBilling().getTransactionType().get(this.type);
        if (typeObject == null) {
            throw new SQLException("Unable to find TransactionType: " + this.type);
        }
        return typeObject;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt("id");
            this.accounting = Account.Name.valueOf(result.getString(COLUMN_ACCOUNTING_name));
            this.packageName = Account.Name.valueOf(result.getString(COLUMN_PACKAGE_name));
            this.type = result.getString(COLUMN_TYPE_name);
            this.description = result.getString("description");
            this.quantity = SQLUtility.parseDecimal3((String)result.getString("quantity"));
            this.rate = MoneyUtil.getMoney(result, "rate.currency", "rate.value");
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(COLUMN_CREATED_name));
            this.createdBy = User.Name.valueOf(result.getString("created_by"));
            this.active = result.getBoolean("active");
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.type = in.readUTF().intern();
            this.description = in.readNullUTF();
            this.quantity = in.readCompressedInt();
            this.rate = MoneyUtil.readNullMoney(in);
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.createdBy = User.Name.valueOf(in.readUTF()).intern();
            this.active = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.packageName.toString() + '|' + this.type + '|' + SQLUtility.formatDecimal3((int)this.quantity) + "\u00d7" + this.rate;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.accounting.toString());
        out.writeUTF(this.packageName.toString());
        out.writeUTF(this.type);
        out.writeNullUTF(this.description);
        out.writeCompressedInt(this.quantity);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            if (this.rate != null && this.rate.getCurrency() == Currency.USD && this.rate.getScale() == 2) {
                out.writeCompressedInt(SafeMath.castInt((long)this.rate.getUnscaledValue()));
            } else {
                out.writeCompressedInt(-1);
            }
        } else {
            MoneyUtil.writeNullMoney(this.rate, out);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeUTF(this.createdBy.toString());
        out.writeBoolean(this.active);
    }
}

