/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.math.NullMath;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.backup.MysqlReplication;
import com.aoindustries.aoserv.client.billing.MonthlyCharge;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.billing.PackageDefinitionLimit;
import com.aoindustries.aoserv.client.billing.Resource;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.PrivateTomcatSite;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class MonthlyChargeTable
extends CachedTableIntegerKey<MonthlyCharge> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("package", true), new AoservTable.OrderBy("pkey", true), new AoservTable.OrderBy("type", true), new AoservTable.OrderBy("created", true)};

    MonthlyChargeTable(AoservConnector connector) {
        super(connector, MonthlyCharge.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public MonthlyCharge get(int pkey) throws SQLException, IOException {
        return (MonthlyCharge)this.getUniqueRow(0, pkey);
    }

    private static <K> void addCount(Map<K, Integer> map, K key, int count) {
        map.put(key, NullMath.add((Integer)map.get(key), (Integer)count));
    }

    private List<MonthlyCharge> getModifiableMonthlyCharges(Administrator administrator, Account sourceAccount, Account billingAccount) throws IOException, SQLException {
        com.aoindustries.aoserv.client.web.Site hs;
        Site hts;
        List cached = super.getRows();
        int len = cached.size();
        ArrayList<MonthlyCharge> charges = new ArrayList<MonthlyCharge>(len);
        for (int c = 0; c < len; ++c) {
            MonthlyCharge mc = (MonthlyCharge)cached.get(c);
            if (sourceAccount != null && !sourceAccount.getName().equals(mc.getPackage().getAccount_name()) || billingAccount != null && !billingAccount.equals(mc.getAccount().getBillingAccount())) continue;
            charges.add(mc);
        }
        Resource httpdResource = this.connector.getBilling().getResource().get("httpd");
        if (httpdResource == null) {
            throw new AssertionError((Object)"httpdResource is null");
        }
        Resource javavmResource = this.connector.getBilling().getResource().get("javavm");
        if (javavmResource == null) {
            throw new AssertionError((Object)"javavmResource is null");
        }
        Resource ipResource = this.connector.getBilling().getResource().get("ip");
        if (ipResource == null) {
            throw new AssertionError((Object)"ipResource is null");
        }
        Resource mysqlReplicationResource = this.connector.getBilling().getResource().get("mysql_replication");
        if (mysqlReplicationResource == null) {
            throw new AssertionError((Object)"mysqlReplicationResource is null");
        }
        Resource emailResource = this.connector.getBilling().getResource().get("email");
        if (emailResource == null) {
            throw new AssertionError((Object)"emailResource is null");
        }
        Resource siteResource = this.connector.getBilling().getResource().get("site");
        if (siteResource == null) {
            throw new AssertionError((Object)"siteResource is null");
        }
        Resource userResource = this.connector.getBilling().getResource().get("user");
        if (userResource == null) {
            throw new AssertionError((Object)"userResource is null");
        }
        HashMap emailsPerPackage = new HashMap();
        HashMap usersPerPackage = new HashMap();
        for (UserServer lsa : this.connector.getLinux().getUserServer().getRows()) {
            User.Name name = lsa.getLinuxAccount_username_id();
            if (name.equals(User.MAIL)) continue;
            User la = lsa.getLinuxAccount();
            HashMap map = la.getType().getName().equals("email") ? emailsPerPackage : usersPerPackage;
            MonthlyChargeTable.addCount(map, la.getUsername().getPackage(), 1);
        }
        HashMap javavmsPerPackage = new HashMap();
        for (SharedTomcat sharedTomcat : this.connector.getWeb_tomcat().getSharedTomcat().getRows()) {
            if (sharedTomcat.isDisabled()) continue;
            MonthlyChargeTable.addCount(javavmsPerPackage, sharedTomcat.getLinuxServerGroup().getLinuxGroup().getPackage(), 1);
        }
        for (com.aoindustries.aoserv.client.web.jboss.Site site : this.connector.getWeb_jboss().getSite().getRows()) {
            hts = site.getHttpdTomcatSite();
            hs = hts.getHttpdSite();
            if (hs.isDisabled()) continue;
            MonthlyChargeTable.addCount(javavmsPerPackage, hs.getPackage(), 1);
        }
        for (PrivateTomcatSite privateTomcatSite : this.connector.getWeb_tomcat().getPrivateTomcatSite().getRows()) {
            hts = privateTomcatSite.getHttpdTomcatSite();
            hs = hts.getHttpdSite();
            if (hs.isDisabled()) continue;
            MonthlyChargeTable.addCount(javavmsPerPackage, hs.getPackage(), 1);
        }
        for (Package package_ : sourceAccount == null ? this.connector.getBilling().getPackage().getRows() : sourceAccount.getPackages()) {
            int userCount;
            int emailCount;
            List<MysqlReplication> fmrs;
            TransactionType addType;
            Money addRate;
            int javavmCount;
            Integer i;
            TransactionType addType2;
            List<IpAddress> ips;
            List<CachedObjectIntegerKey> hss;
            Account packAccount = package_.getAccount();
            boolean active = packAccount.getCanceled() == null;
            Account packBillingAccount = packAccount.getBillingAccount();
            if (billingAccount != null && !billingAccount.equals(packBillingAccount)) continue;
            PackageDefinition packageDefinition = package_.getPackageDefinition();
            Money rate = packageDefinition.getMonthlyRate();
            charges.add(new MonthlyCharge(this, packBillingAccount, package_, packageDefinition.getMonthlyRateTransactionType(), packageDefinition.getDisplay(), 1000, rate, administrator, active));
            PackageDefinitionLimit limit = packageDefinition.getLimit(httpdResource);
            if (!(limit != null && limit.getSoftLimit() == -1 || (hss = package_.getHttpdServers()).isEmpty())) {
                if (limit == null) {
                    throw new SQLException("HttpdServers exist, but no limit defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                }
                if (hss.size() > limit.getSoftLimit()) {
                    Money addRate2 = limit.getAdditionalRate();
                    if (addRate2 == null) {
                        throw new SQLException("Additional HttpdServers exist, but no additional rate defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    TransactionType addType22 = limit.getAdditionalTransactionType();
                    if (addType22 == null) {
                        throw new SQLException("Additional HttpdServers exist, but no additional TransactionType defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    charges.add(new MonthlyCharge(this, packBillingAccount, package_, addType22, "Additional HTTP Servers (" + limit.getSoftLimit() + " included with package, have " + hss.size() + ")", (hss.size() - limit.getSoftLimit()) * 1000, addRate2, administrator, active));
                }
            }
            if (!((limit = packageDefinition.getLimit(ipResource)) != null && limit.getSoftLimit() == -1 || (ips = package_.getIpAddresses()).isEmpty() || (ips = ips.stream().filter(ip -> {
                InetAddress ia = ip.getInetAddress();
                return !ia.isLoopback() && !ia.isUnspecified() && !ia.isUniqueLocal();
            }).collect(Collectors.toList())).isEmpty())) {
                if (limit == null) {
                    throw new SQLException("IpAddresses exist, but no limit defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                }
                if (ips.size() > limit.getSoftLimit()) {
                    Money addRate2 = limit.getAdditionalRate();
                    if (addRate2 == null) {
                        throw new SQLException("Additional IpAddresses exist, but no additional rate defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    addType2 = limit.getAdditionalTransactionType();
                    if (addType2 == null) {
                        throw new SQLException("Additional IpAddresses exist, but no additional TransactionType defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    charges.add(new MonthlyCharge(this, packBillingAccount, package_, addType2, "Additional IP Addresses (" + limit.getSoftLimit() + " included with package, have " + ips.size() + ")", (ips.size() - limit.getSoftLimit()) * 1000, addRate2, administrator, active));
                }
            }
            if (((limit = packageDefinition.getLimit(javavmResource)) == null || limit.getSoftLimit() != -1) && (i = (Integer)javavmsPerPackage.get(package_)) != null && (javavmCount = i.intValue()) > 0) {
                if (limit == null) {
                    throw new SQLException("Java virtual machines exist, but no limit defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                }
                if (javavmCount > limit.getSoftLimit()) {
                    addRate = limit.getAdditionalRate();
                    if (addRate == null) {
                        throw new SQLException("Additional Java virtual machines exist, but no additional rate defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    addType = limit.getAdditionalTransactionType();
                    if (addType == null) {
                        throw new SQLException("Additional Java virtual machines exist, but no additional TransactionType defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    charges.add(new MonthlyCharge(this, packBillingAccount, package_, addType, "Additional Java Virtual Machines (" + limit.getSoftLimit() + " included with package, have " + javavmCount + ")", (javavmCount - limit.getSoftLimit()) * 1000, addRate, administrator, active));
                }
            }
            if (!((limit = packageDefinition.getLimit(mysqlReplicationResource)) != null && limit.getSoftLimit() == -1 || (fmrs = package_.getFailoverMysqlReplications()).isEmpty())) {
                if (limit == null) {
                    throw new SQLException("FailoverMysqlReplications exist, but no limit defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                }
                if (fmrs.size() > limit.getSoftLimit()) {
                    Money addRate3 = limit.getAdditionalRate();
                    if (addRate3 == null) {
                        throw new SQLException("Additional FailoverMysqlReplications exist, but no additional rate defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    addType2 = limit.getAdditionalTransactionType();
                    if (addType2 == null) {
                        throw new SQLException("Additional FailoverMysqlReplications exist, but no additional TransactionType defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    charges.add(new MonthlyCharge(this, packBillingAccount, package_, addType2, "Additional MySQL Replications (" + limit.getSoftLimit() + " included with package, have " + fmrs.size() + ")", (fmrs.size() - limit.getSoftLimit()) * 1000, addRate3, administrator, active));
                }
            }
            if (((limit = packageDefinition.getLimit(emailResource)) == null || limit.getSoftLimit() != -1) && (i = (Integer)emailsPerPackage.get(package_)) != null && (emailCount = i.intValue()) > 0) {
                if (limit == null) {
                    throw new SQLException("Email inboxes exist, but no limit defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                }
                if (emailCount > limit.getSoftLimit()) {
                    addRate = limit.getAdditionalRate();
                    if (addRate == null) {
                        throw new SQLException("Additional Email inboxes exist, but no additional rate defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    addType = limit.getAdditionalTransactionType();
                    if (addType == null) {
                        throw new SQLException("Additional Email inboxes exist, but no additional TransactionType defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    charges.add(new MonthlyCharge(this, packBillingAccount, package_, addType, "Additional Email Inboxes (" + limit.getSoftLimit() + " included with package, have " + emailCount + ")", (emailCount - limit.getSoftLimit()) * 1000, addRate, administrator, active));
                }
            }
            if (!((limit = packageDefinition.getLimit(siteResource)) != null && limit.getSoftLimit() == -1 || (hss = package_.getHttpdSites()).isEmpty())) {
                if (limit == null) {
                    throw new SQLException("HttpdSites exist, but no limit defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                }
                if (hss.size() > limit.getSoftLimit()) {
                    Money addRate4 = limit.getAdditionalRate();
                    if (addRate4 == null) {
                        throw new SQLException("Additional HttpdSites exist, but no additional rate defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    addType2 = limit.getAdditionalTransactionType();
                    if (addType2 == null) {
                        throw new SQLException("Additional HttpdSites exist, but no additional TransactionType defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
                    }
                    charges.add(new MonthlyCharge(this, packBillingAccount, package_, addType2, "Additional Web Sites (" + limit.getSoftLimit() + " included with package, have " + hss.size() + ")", (hss.size() - limit.getSoftLimit()) * 1000, addRate4, administrator, active));
                }
            }
            if ((limit = packageDefinition.getLimit(userResource)) != null && limit.getSoftLimit() == -1 || (i = (Integer)usersPerPackage.get(package_)) == null || (userCount = i.intValue()) <= 0) continue;
            if (limit == null) {
                throw new SQLException("Shell accounts exist, but no limit defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
            }
            if (userCount <= limit.getSoftLimit()) continue;
            addRate = limit.getAdditionalRate();
            if (addRate == null) {
                throw new SQLException("Additional Shell accounts exist, but no additional rate defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
            }
            addType = limit.getAdditionalTransactionType();
            if (addType == null) {
                throw new SQLException("Additional Shell accounts exist, but no additional TransactionType defined for Package=" + package_.getPkey() + ", PackageDefinition=" + packageDefinition.getPkey());
            }
            charges.add(new MonthlyCharge(this, packBillingAccount, package_, addType, "Additional Shell Accounts (" + limit.getSoftLimit() + " included with package, have " + userCount + ")", (userCount - limit.getSoftLimit()) * 1000, addRate, administrator, active));
        }
        this.sortIfNeeded(charges);
        return charges;
    }

    public List<MonthlyCharge> getMonthlyCharges(Administrator administrator, Account sourceAccount, Account billingAccount) throws IOException, SQLException {
        return Collections.unmodifiableList(this.getModifiableMonthlyCharges(administrator, sourceAccount, billingAccount));
    }

    public List<MonthlyCharge> getMonthlyCharges(Account sourceAccount, Account billingAccount) throws SQLException, IOException {
        return this.getMonthlyCharges(this.connector.getCurrentAdministrator(), sourceAccount, billingAccount);
    }

    @Override
    public List<MonthlyCharge> getRows() throws SQLException, IOException {
        return this.getMonthlyCharges(this.connector.getCurrentAdministrator(), null, null);
    }

    @Override
    public List<MonthlyCharge> getRowsCopy() throws IOException, SQLException {
        return this.getModifiableMonthlyCharges(this.connector.getCurrentAdministrator(), null, null);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.MONTHLY_CHARGES;
    }

    @Override
    public List<MonthlyCharge> getIndexedRows(int col, Object value) {
        throw new UnsupportedOperationException("Indexed rows are not supported on MonthlyChargeTable");
    }
}

