/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.SQLUtility;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.NoticeLogBalance;
import com.aoindustries.aoserv.client.billing.NoticeType;
import com.aoindustries.aoserv.client.billing.Transaction;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public final class NoticeLog
extends CachedObjectIntegerKey<NoticeLog> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_ACCOUNTING = 2;
    static final String COLUMN_PKEY_name = "pkey";
    static final String COLUMN_CREATE_TIME_name = "create_time";
    public static final int NO_TRANSACTION = -1;
    private UnmodifiableTimestamp createTime;
    private Account.Name accounting;
    private String billingContact;
    private Email billingEmail;
    private String noticeType;
    private int transid;
    private int balance;

    @Deprecated
    public NoticeLog() {
    }

    public int getId() {
        return this.pkey;
    }

    public UnmodifiableTimestamp getCreateTime() {
        return this.createTime;
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return obj;
    }

    public String getBillingContact() {
        return this.billingContact;
    }

    public Email getBillingEmail() {
        return this.billingEmail;
    }

    public String getNoticeType_type() {
        return this.noticeType;
    }

    public NoticeType getNoticeType() throws SQLException, IOException {
        NoticeType obj = this.table.getConnector().getBilling().getNoticeType().get(this.noticeType);
        if (obj == null) {
            throw new SQLException("Unable to find NoticeType: " + this.noticeType);
        }
        return obj;
    }

    public Integer getTransaction_id() {
        return this.transid == -1 ? null : Integer.valueOf(this.transid);
    }

    public Transaction getTransaction() throws IOException, SQLException {
        if (this.transid == -1) {
            return null;
        }
        Transaction obj = this.table.getConnector().getBilling().getTransaction().get(this.transid);
        if (obj == null) {
            throw new SQLException("Unable to find Transaction: " + this.transid);
        }
        return obj;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.createTime;
            }
            case 2: {
                return this.accounting;
            }
            case 3: {
                return this.billingContact;
            }
            case 4: {
                return this.billingEmail;
            }
            case 5: {
                return this.noticeType;
            }
            case 6: {
                return this.getTransaction_id();
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.NOTICE_LOG;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt("id");
            this.createTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(COLUMN_CREATE_TIME_name));
            this.accounting = Account.Name.valueOf(result.getString("accounting"));
            this.billingContact = result.getString("billing_contact");
            this.billingEmail = Email.valueOf((String)result.getString("billing_email"));
            this.noticeType = result.getString("notice_type");
            this.transid = result.getInt("transid");
            if (result.wasNull()) {
                this.transid = -1;
            }
            this.balance = SQLUtility.parseDecimal2((String)result.getString("balance"));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.createTime = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.billingContact = in.readUTF();
            this.billingEmail = Email.valueOf((String)in.readUTF());
            this.noticeType = in.readUTF().intern();
            this.transid = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.pkey + "|" + this.accounting + '|' + this.noticeType;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.createTime.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.createTime, (DataOutputStream)out);
        }
        out.writeUTF(this.accounting.toString());
        out.writeUTF(this.billingContact);
        out.writeUTF(this.billingEmail.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeCompressedInt(this.balance);
        }
        out.writeUTF(this.noticeType);
        out.writeCompressedInt(this.transid);
    }

    public List<NoticeLogBalance> getBalances() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getNoticeLogBalance().getNoticeLogBalances(this);
    }
}

