/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Money;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.billing.MoneyUtil;
import com.aoindustries.aoserv.client.billing.NoticeLog;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class NoticeLogBalance
extends CachedObjectIntegerKey<NoticeLogBalance> {
    static final int COLUMN_id = 0;
    static final int COLUMN_noticeLog = 1;
    static final String COLUMN_noticeLog_name = "noticeLog";
    static final String COLUMN_balance_name = "balance";
    private int noticeLog;
    private Money balance;

    @Deprecated
    public NoticeLogBalance() {
    }

    public int getId() {
        return this.pkey;
    }

    public int getNoticeLog_id() {
        return this.noticeLog;
    }

    public NoticeLog getNoticeLog() throws SQLException, IOException {
        NoticeLog obj = this.table.getConnector().getBilling().getNoticeLog().get(this.noticeLog);
        if (obj == null) {
            throw new SQLException("Unable to find NoticeLog: " + this.noticeLog);
        }
        return obj;
    }

    public Money getBalance() {
        return this.balance;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.noticeLog;
            }
            case 2: {
                return this.balance;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.NoticeLogBalance;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt("id");
        this.noticeLog = result.getInt(COLUMN_noticeLog_name);
        this.balance = MoneyUtil.getMoney(result, "balance.currency", "balance.value");
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.noticeLog = in.readCompressedInt();
        this.balance = MoneyUtil.readMoney(in);
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getNoticeLog().toStringImpl() + "->" + this.balance;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.noticeLog);
        MoneyUtil.writeMoney(this.balance, out);
    }
}

