/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.NoticeLog;
import com.aoindustries.aoserv.client.billing.NoticeType;
import com.aoindustries.aoserv.client.billing.Transaction;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class NoticeLogTable
extends CachedTableIntegerKey<NoticeLog> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("create_time", true), new AoservTable.OrderBy("pkey", true)};

    NoticeLogTable(AoservConnector connector) {
        super(connector, NoticeLog.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addNoticeLog(Account account, String billingContact, Email emailAddress, NoticeType type, Transaction trans) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.NOTICE_LOG, account.getName().toString(), billingContact, emailAddress, type.getType(), trans == null ? -1 : trans.getTransid()});
    }

    @Override
    public NoticeLog get(int pkey) throws IOException, SQLException {
        return (NoticeLog)this.getUniqueRow(0, pkey);
    }

    public List<NoticeLog> getNoticeLogs(Account bu) throws IOException, SQLException {
        return this.getIndexedRows(2, bu.getName());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.NOTICE_LOG;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_notice_log")) {
            if (Aosh.checkParamCount("add_notice_log", args, 5, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addNoticeLog(Aosh.parseAccountingCode(args[1], "business"), args[2], Aosh.parseEmail(args[3], "email_address"), args[4], args[5].isEmpty() ? -1 : Aosh.parseInt(args[5], "transid")));
                out.flush();
            }
            return true;
        }
        return false;
    }
}

