/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.HostAddress;
import com.aoapps.net.InetAddress;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.backup.BackupReport;
import com.aoindustries.aoserv.client.backup.MysqlReplication;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.dns.Zone;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.Pipe;
import com.aoindustries.aoserv.client.email.SendmailServer;
import com.aoindustries.aoserv.client.email.SmtpRelay;
import com.aoindustries.aoserv.client.email.SmtpRelayType;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupType;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.scm.CvsRepository;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public final class Package
extends CachedObjectIntegerKey<Package>
implements Disablable,
Comparable<Package> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_NAME = 1;
    static final int COLUMN_ACCOUNTING = 2;
    static final int COLUMN_PACKAGE_DEFINITION = 3;
    public static final String COLUMN_NAME_name = "name";
    public static final int DEFAULT_EMAIL_IN_BURST = 1000;
    public static final float DEFAULT_EMAIL_IN_RATE = 10.0f;
    public static final int DEFAULT_EMAIL_OUT_BURST = 200;
    public static final float DEFAULT_EMAIL_OUT_RATE = 0.2f;
    public static final int DEFAULT_EMAIL_RELAY_BURST = 100;
    public static final float DEFAULT_EMAIL_RELAY_RATE = 0.1f;
    private Account.Name name;
    private Account.Name account;
    private int packageDefinition;
    private UnmodifiableTimestamp created;
    private User.Name createdBy;
    private int disableLog;
    private int emailInBurst;
    private float emailInRate;
    private int emailOutBurst;
    private float emailOutRate;
    private int emailRelayBurst;
    private float emailRelayRate;

    @Deprecated
    public Package() {
    }

    @Override
    public String toStringImpl() {
        return this.name.toString();
    }

    public void addDnsZone(String zone, InetAddress ip, int ttl) throws IOException, SQLException {
        this.table.getConnector().getDns().getZone().addDnsZone(this, zone, ip, ttl);
    }

    public int addEmailSmtpRelay(Server aoServer, HostAddress host, SmtpRelayType type, long duration) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSmtpRelay().addEmailSmtpRelay(this, aoServer, host, type, duration);
    }

    public void addLinuxGroup(Group.Name name, GroupType type) throws IOException, SQLException {
        this.addLinuxGroup(name, type.getName());
    }

    public void addLinuxGroup(Group.Name name, String type) throws IOException, SQLException {
        this.table.getConnector().getLinux().getGroup().addLinuxGroup(name, this, type);
    }

    public void addUsername(User.Name username) throws IOException, SQLException {
        this.table.getConnector().getAccount().getUser().addUsername(this, username);
    }

    @Override
    public boolean canDisable() throws IOException, SQLException {
        if (this.disableLog != -1) {
            return false;
        }
        for (SharedTomcat hst : this.getHttpdSharedTomcats()) {
            if (hst.isDisabled()) continue;
            return false;
        }
        for (Pipe ep : this.getEmailPipes()) {
            if (ep.isDisabled()) continue;
            return false;
        }
        for (CvsRepository cr : this.getCvsRepositories()) {
            if (cr.isDisabled()) continue;
            return false;
        }
        for (com.aoindustries.aoserv.client.account.User un : this.getUsernames()) {
            if (un.isDisabled()) continue;
            return false;
        }
        for (Site hs : this.getHttpdSites()) {
            if (hs.isDisabled()) continue;
            return false;
        }
        for (com.aoindustries.aoserv.client.email.List el : this.getEmailLists()) {
            if (el.isDisabled()) continue;
            return false;
        }
        for (SmtpRelay ssr : this.getEmailSmtpRelays()) {
            if (ssr.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getAccount().isDisabled();
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.PACKAGES, dl.getPkey(), this.name});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.PACKAGES, this.name});
    }

    public List<BackupReport> getBackupReports() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getBackupReport().getBackupReports(this);
    }

    public Account.Name getAccount_name() {
        return this.account;
    }

    public Account getAccount() throws SQLException, IOException {
        Account accountingObject = this.table.getConnector().getAccount().getAccount().get(this.account);
        if (accountingObject == null) {
            throw new SQLException("Unable to find Account: " + this.account);
        }
        return accountingObject;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.account;
            }
            case 3: {
                return this.packageDefinition;
            }
            case 4: {
                return this.created;
            }
            case 5: {
                return this.createdBy;
            }
            case 6: {
                return this.getDisableLog_id();
            }
            case 7: {
                return this.emailInBurst == -1 ? null : Integer.valueOf(this.emailInBurst);
            }
            case 8: {
                return Float.isNaN(this.emailInRate) ? null : Float.valueOf(this.emailInRate);
            }
            case 9: {
                return this.emailOutBurst == -1 ? null : Integer.valueOf(this.emailOutBurst);
            }
            case 10: {
                return Float.isNaN(this.emailOutRate) ? null : Float.valueOf(this.emailOutRate);
            }
            case 11: {
                return this.emailRelayBurst == -1 ? null : Integer.valueOf(this.emailRelayBurst);
            }
            case 12: {
                return Float.isNaN(this.emailRelayRate) ? null : Float.valueOf(this.emailRelayRate);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    public Administrator getCreatedBy() throws SQLException, IOException {
        Administrator obj = this.table.getConnector().getAccount().getUser().get(this.createdBy).getAdministrator();
        if (obj == null) {
            throw new SQLException("Unable to find Administrator: " + this.createdBy);
        }
        return obj;
    }

    public List<CvsRepository> getCvsRepositories() throws IOException, SQLException {
        return this.table.getConnector().getScm().getCvsRepository().getCvsRepositories(this);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    public Integer getDisableLog_id() {
        return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public int getEmailInBurst() {
        return this.emailInBurst;
    }

    public float getEmailInRate() {
        return this.emailInRate;
    }

    public int getEmailOutBurst() {
        return this.emailOutBurst;
    }

    public float getEmailOutRate() {
        return this.emailOutRate;
    }

    public int getEmailRelayBurst() {
        return this.emailRelayBurst;
    }

    public float getEmailRelayRate() {
        return this.emailRelayRate;
    }

    public List<Zone> getDnsZones() throws IOException, SQLException {
        return this.table.getConnector().getDns().getZone().getDnsZones(this);
    }

    public List<com.aoindustries.aoserv.client.email.List> getEmailLists() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getList().getEmailLists(this);
    }

    public List<Pipe> getEmailPipes() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipe().getEmailPipes(this);
    }

    public List<SharedTomcat> getHttpdSharedTomcats() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcat().getHttpdSharedTomcats(this);
    }

    public List<HttpdServer> getHttpdServers() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getHttpdServer().getHttpdServers(this);
    }

    public List<Site> getHttpdSites() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getSite().getHttpdSites(this);
    }

    public List<IpAddress> getIpAddresses() throws IOException, SQLException {
        return this.table.getConnector().getNet().getIpAddress().getIpAddresses(this);
    }

    public List<Group> getLinuxGroups() throws IOException, SQLException {
        return this.table.getConnector().getLinux().getGroup().getLinuxGroups(this);
    }

    public List<com.aoindustries.aoserv.client.mysql.Database> getMysqlDatabases() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getDatabase().getMysqlDatabases(this);
    }

    public List<MysqlReplication> getFailoverMysqlReplications() throws IOException, SQLException {
        return this.table.getConnector().getBackup().getMysqlReplication().getFailoverMysqlReplications(this);
    }

    public List<User> getMysqlUsers() throws IOException, SQLException {
        return this.table.getConnector().getMysql().getUser().getMysqlUsers(this);
    }

    public Account.Name getName() {
        return this.name;
    }

    public List<Bind> getNetBinds() throws IOException, SQLException {
        return this.table.getConnector().getNet().getBind().getNetBinds(this);
    }

    public List<Bind> getNetBinds(IpAddress ip) throws IOException, SQLException {
        return this.table.getConnector().getNet().getBind().getNetBinds(this, ip);
    }

    public int getPackageDefinition_id() {
        return this.packageDefinition;
    }

    public PackageDefinition getPackageDefinition() throws SQLException, IOException {
        PackageDefinition pd = this.table.getConnector().getBilling().getPackageDefinition().get(this.packageDefinition);
        if (pd == null) {
            throw new SQLException("Unable to find PackageDefinition: " + this.packageDefinition);
        }
        return pd;
    }

    public List<Database> getPostgresDatabases() throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getDatabase().getPostgresDatabases(this);
    }

    public List<com.aoindustries.aoserv.client.postgresql.User> getPostgresUsers() throws SQLException, IOException {
        return this.table.getConnector().getPostgresql().getUser().getPostgresUsers(this);
    }

    public List<SendmailServer> getSendmailServers() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSendmailServer().getSendmailServers(this);
    }

    public Host getHost(String name) throws IOException, SQLException {
        return this.table.getConnector().getNet().getHost().getHost(this, name);
    }

    public List<Host> getServers() throws IOException, SQLException {
        return this.table.getConnector().getNet().getHost().getServers(this);
    }

    public List<Domain> getEmailDomains() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getDomain().getEmailDomains(this);
    }

    public List<SmtpRelay> getEmailSmtpRelays() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getSmtpRelay().getEmailSmtpRelays(this);
    }

    public List<Certificate> getSslCertificates() throws IOException, SQLException {
        return this.table.getConnector().getPki().getCertificate().getSslCertificates(this);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PACKAGES;
    }

    public List<com.aoindustries.aoserv.client.account.User> getUsernames() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getUser().getUsernames(this);
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.name = Account.Name.valueOf(result.getString(pos++));
            this.account = Account.Name.valueOf(result.getString(pos++));
            this.packageDefinition = result.getInt(pos++);
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.createdBy = User.Name.valueOf(result.getString(pos++));
            this.disableLog = result.getInt(pos++);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
            this.emailInBurst = result.getInt(pos++);
            if (result.wasNull()) {
                this.emailInBurst = -1;
            }
            this.emailInRate = result.getFloat(pos++);
            if (result.wasNull()) {
                this.emailInRate = Float.NaN;
            }
            this.emailOutBurst = result.getInt(pos++);
            if (result.wasNull()) {
                this.emailOutBurst = -1;
            }
            this.emailOutRate = result.getFloat(pos++);
            if (result.wasNull()) {
                this.emailOutRate = Float.NaN;
            }
            this.emailRelayBurst = result.getInt(pos++);
            if (result.wasNull()) {
                this.emailRelayBurst = -1;
            }
            this.emailRelayRate = result.getFloat(pos++);
            if (result.wasNull()) {
                this.emailRelayRate = Float.NaN;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.name = Account.Name.valueOf(in.readUTF()).intern();
            this.account = Account.Name.valueOf(in.readUTF()).intern();
            this.packageDefinition = in.readCompressedInt();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.createdBy = User.Name.valueOf(in.readUTF()).intern();
            this.disableLog = in.readCompressedInt();
            this.emailInBurst = in.readCompressedInt();
            this.emailInRate = in.readFloat();
            this.emailOutBurst = in.readCompressedInt();
            this.emailOutRate = in.readFloat();
            this.emailRelayBurst = in.readCompressedInt();
            this.emailRelayRate = in.readFloat();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name.toString());
        out.writeUTF(this.account.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_122) <= 0) {
            out.writeUTF("unknown");
            out.writeCompressedInt(0);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_123) >= 0) {
            out.writeCompressedInt(this.packageDefinition);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        out.writeUTF(this.createdBy.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_122) <= 0) {
            out.writeCompressedInt(-1);
            out.writeCompressedInt(200);
            out.writeCompressedInt(-1);
            out.writeCompressedInt(100);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeCompressedInt(256);
            out.writeLong(0x4000000L);
            out.writeCompressedInt(256);
            out.writeLong(0x4000000L);
        }
        out.writeCompressedInt(this.disableLog);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_24) >= 0) {
            out.writeCompressedInt(this.emailInBurst);
            out.writeFloat(this.emailInRate);
            out.writeCompressedInt(this.emailOutBurst);
            out.writeFloat(this.emailOutRate);
            out.writeCompressedInt(this.emailRelayBurst);
            out.writeFloat(this.emailRelayRate);
        }
    }

    @Override
    public int compareTo(Package o) {
        return this.name.compareTo(o.name);
    }
}

