/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.math.SafeMath;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.Currency;
import com.aoindustries.aoserv.client.billing.MoneyUtil;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.billing.PackageCategory;
import com.aoindustries.aoserv.client.billing.PackageDefinitionLimit;
import com.aoindustries.aoserv.client.billing.Resource;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class PackageDefinition
extends CachedObjectIntegerKey<PackageDefinition>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    static final String COLUMN_CATEGORY_name = "category";
    static final String COLUMN_monthlyRate_name = "monthlyRate";
    static final String COLUMN_NAME_name = "name";
    static final String COLUMN_VERSION_name = "version";
    private Account.Name accounting;
    private String category;
    private String name;
    private String version;
    private String display;
    private String description;
    private Money setupFee;
    private String setupFeeTransactionType;
    private Money monthlyRate;
    private String monthlyRateTransactionType;
    private boolean active;
    private boolean approved;

    @Deprecated
    public PackageDefinition() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.accounting;
            }
            case 2: {
                return this.category;
            }
            case 3: {
                return this.name;
            }
            case 4: {
                return this.version;
            }
            case 5: {
                return this.display;
            }
            case 6: {
                return this.description;
            }
            case 7: {
                return this.setupFee;
            }
            case 8: {
                return this.setupFeeTransactionType;
            }
            case 9: {
                return this.monthlyRate;
            }
            case 10: {
                return this.monthlyRateTransactionType;
            }
            case 11: {
                return this.active;
            }
            case 12: {
                return this.approved;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws IOException, SQLException {
        return this.table.getConnector().getAccount().getAccount().get(this.accounting);
    }

    public String getPackageCategory_name() {
        return this.category;
    }

    public PackageCategory getPackageCategory() throws SQLException, IOException {
        PackageCategory pc = this.table.getConnector().getBilling().getPackageCategory().get(this.category);
        if (pc == null) {
            throw new SQLException("Unable to find PackageCategory: " + this.category);
        }
        return pc;
    }

    public List<Package> getPackages() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().getPackages(this);
    }

    public PackageDefinitionLimit getLimit(Resource resource) throws IOException, SQLException {
        if (resource == null) {
            throw new AssertionError((Object)"resource is null");
        }
        return this.table.getConnector().getBilling().getPackageDefinitionLimit().getPackageDefinitionLimit(this, resource);
    }

    public List<PackageDefinitionLimit> getLimits() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackageDefinitionLimit().getPackageDefinitionLimits(this);
    }

    public void setLimits(final PackageDefinitionLimit[] limits) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_PACKAGE_DEFINITION_LIMITS, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(PackageDefinition.this.pkey);
                out.writeCompressedInt(limits.length);
                for (PackageDefinitionLimit limit : limits) {
                    out.writeUTF(limit.getResource_name());
                    out.writeCompressedInt(limit.getSoftLimit());
                    out.writeCompressedInt(limit.getHardLimit());
                    MoneyUtil.writeNullMoney(limit.getAdditionalRate(), out);
                    out.writeNullUTF(limit.getAdditionalTransactionType_name());
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                PackageDefinition.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getDescription() {
        return this.description;
    }

    public Money getSetupFee() {
        return this.setupFee;
    }

    public TransactionType getSetupFeeTransactionType() throws SQLException, IOException {
        if (this.setupFeeTransactionType == null) {
            return null;
        }
        TransactionType tt = this.table.getConnector().getBilling().getTransactionType().get(this.setupFeeTransactionType);
        if (tt == null) {
            throw new SQLException("Unable to find TransactionType: " + this.setupFeeTransactionType);
        }
        return tt;
    }

    public Money getMonthlyRate() {
        return this.monthlyRate;
    }

    public TransactionType getMonthlyRateTransactionType() throws SQLException, IOException {
        if (this.monthlyRateTransactionType == null) {
            return null;
        }
        TransactionType tt = this.table.getConnector().getBilling().getTransactionType().get(this.monthlyRateTransactionType);
        if (tt == null) {
            throw new SQLException("Unable to find TransactionType: " + this.monthlyRateTransactionType);
        }
        return tt;
    }

    public boolean isActive() {
        return this.active;
    }

    public int copy() throws IOException, SQLException {
        return this.table.getConnector().requestIntQueryInvalidating(true, AoservProtocol.CommandId.COPY_PACKAGE_DEFINITION, this.pkey);
    }

    public void setActive(boolean active) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_PACKAGE_DEFINITION_ACTIVE, this.pkey, active);
    }

    public boolean isApproved() {
        return this.approved;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PACKAGE_DEFINITIONS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt("id");
            this.accounting = Account.Name.valueOf(result.getString(COLUMN_ACCOUNTING_name));
            this.category = result.getString(COLUMN_CATEGORY_name);
            this.name = result.getString(COLUMN_NAME_name);
            this.version = result.getString(COLUMN_VERSION_name);
            this.display = result.getString("display");
            this.description = result.getString("description");
            this.setupFee = MoneyUtil.getMoney(result, "setupFee.currency", "setupFee.value");
            this.setupFeeTransactionType = result.getString("setup_fee_transaction_type");
            this.monthlyRate = MoneyUtil.getMoney(result, "monthlyRate.currency", "monthlyRate.value");
            this.monthlyRateTransactionType = result.getString("monthly_rate_transaction_type");
            this.active = result.getBoolean("active");
            this.approved = result.getBoolean("approved");
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.accounting = Account.Name.valueOf(in.readUTF()).intern();
            this.category = in.readUTF().intern();
            this.name = in.readUTF();
            this.version = in.readUTF();
            this.display = in.readUTF();
            this.description = in.readUTF();
            this.setupFee = MoneyUtil.readNullMoney(in);
            this.setupFeeTransactionType = InternUtils.intern((String)in.readNullUTF());
            this.monthlyRate = MoneyUtil.readNullMoney(in);
            this.monthlyRateTransactionType = InternUtils.intern((String)in.readNullUTF());
            this.active = in.readBoolean();
            this.approved = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.display;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.accounting.toString());
        out.writeUTF(this.category);
        out.writeUTF(this.name);
        out.writeUTF(this.version);
        out.writeUTF(this.display);
        out.writeUTF(this.description);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            if (this.setupFee != null && this.setupFee.getCurrency() == Currency.USD && this.setupFee.getScale() == 2) {
                out.writeCompressedInt(SafeMath.castInt((long)this.setupFee.getUnscaledValue()));
            } else {
                out.writeCompressedInt(-1);
            }
        } else {
            MoneyUtil.writeNullMoney(this.setupFee, out);
        }
        out.writeNullUTF(this.setupFeeTransactionType);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            if (this.monthlyRate != null && this.monthlyRate.getCurrency() == Currency.USD && this.monthlyRate.getScale() == 2) {
                out.writeCompressedInt(SafeMath.castInt((long)this.monthlyRate.getUnscaledValue()));
            } else {
                out.writeCompressedInt(-1);
            }
        } else {
            MoneyUtil.writeNullMoney(this.monthlyRate, out);
        }
        out.writeNullUTF(this.monthlyRateTransactionType);
        out.writeBoolean(this.active);
        out.writeBoolean(this.approved);
    }

    public List<CannotRemoveReason<Package>> getCannotRemoveReasons() throws IOException, SQLException {
        ArrayList<CannotRemoveReason<Package>> reasons = new ArrayList<CannotRemoveReason<Package>>(1);
        List<Package> packs = this.getPackages();
        if (!packs.isEmpty()) {
            reasons.add(new CannotRemoveReason<Package>("Used by " + packs.size() + " " + (packs.size() == 1 ? "package" : "packages"), packs));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.PACKAGE_DEFINITIONS, this.pkey});
    }

    public void update(final Account business, final PackageCategory category, final String name, final String version, final String display, final String description, final Money setupFee, final TransactionType setupFeeTransactionType, final Money monthlyRate, final TransactionType monthlyRateTransactionType) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.UPDATE_PACKAGE_DEFINITION, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(PackageDefinition.this.pkey);
                out.writeUTF(business.getName().toString());
                out.writeUTF(category.getName());
                out.writeUTF(name);
                out.writeUTF(version);
                out.writeUTF(display);
                out.writeUTF(description);
                MoneyUtil.writeNullMoney(setupFee, out);
                out.writeBoolean(setupFeeTransactionType != null);
                if (setupFeeTransactionType != null) {
                    out.writeUTF(setupFeeTransactionType.getName());
                }
                MoneyUtil.writeMoney(monthlyRate, out);
                out.writeUTF(monthlyRateTransactionType.getName());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                PackageDefinition.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }
}

