/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.math.SafeMath;
import com.aoapps.lang.util.InternUtils;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.billing.Currency;
import com.aoindustries.aoserv.client.billing.MoneyUtil;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.billing.Resource;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class PackageDefinitionLimit
extends CachedObjectIntegerKey<PackageDefinitionLimit> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_PACKAGE_DEFINITION = 1;
    static final String COLUMN_RESOURCE_name = "resource";
    static final String COLUMN_PACKAGE_DEFINITION_name = "package_definition";
    public static final int UNLIMITED = -1;
    private int packageDefinition;
    private String resource;
    private int softLimit;
    private int hardLimit;
    private Money additionalRate;
    private String additionalTransactionType;

    @Deprecated
    public PackageDefinitionLimit() {
    }

    public PackageDefinitionLimit(PackageDefinition packageDefinition, Resource resource, int softLimit, int hardLimit, Money additionalRate, TransactionType additionalTransactionType) {
        this.pkey = -1;
        this.packageDefinition = packageDefinition.getPkey();
        this.resource = resource.getName();
        this.softLimit = softLimit;
        this.hardLimit = hardLimit;
        this.additionalRate = additionalRate;
        this.additionalTransactionType = additionalTransactionType == null ? null : additionalTransactionType.getName();
        this.setTable(packageDefinition.getTable().getConnector().getBilling().getPackageDefinitionLimit());
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.packageDefinition;
            }
            case 2: {
                return this.resource;
            }
            case 3: {
                return this.softLimit == -1 ? null : Integer.valueOf(this.softLimit);
            }
            case 4: {
                return this.hardLimit == -1 ? null : Integer.valueOf(this.hardLimit);
            }
            case 5: {
                return this.additionalRate;
            }
            case 6: {
                return this.additionalTransactionType;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getPackageDefinition_id() {
        return this.packageDefinition;
    }

    public PackageDefinition getPackageDefinition() throws IOException, SQLException {
        PackageDefinition pd = this.table.getConnector().getBilling().getPackageDefinition().get(this.packageDefinition);
        if (pd == null) {
            throw new SQLException("Unable to find PackageDefinition: " + this.packageDefinition);
        }
        return pd;
    }

    public String getResource_name() {
        return this.resource;
    }

    public Resource getResource() throws SQLException, IOException {
        Resource r = this.table.getConnector().getBilling().getResource().get(this.resource);
        if (r == null) {
            throw new SQLException("Unable to find Resource: " + this.resource);
        }
        return r;
    }

    public int getSoftLimit() {
        return this.softLimit;
    }

    public String getSoftLimitDisplayUnit() throws IOException, SQLException {
        return this.softLimit == -1 ? null : this.getResource().getDisplayUnit(this.softLimit);
    }

    public int getHardLimit() {
        return this.hardLimit;
    }

    public String getHardLimitDisplayUnit() throws IOException, SQLException {
        return this.hardLimit == -1 ? null : this.getResource().getDisplayUnit(this.hardLimit);
    }

    public Money getAdditionalRate() {
        return this.additionalRate;
    }

    public String getAdditionalRatePerUnit() throws IOException, SQLException {
        return this.additionalRate == null ? null : this.getResource().getPerUnit(this.additionalRate);
    }

    public String getAdditionalTransactionType_name() {
        return this.additionalTransactionType;
    }

    public TransactionType getAdditionalTransactionType() throws SQLException, IOException {
        if (this.additionalTransactionType == null) {
            return null;
        }
        TransactionType tt = this.table.getConnector().getBilling().getTransactionType().get(this.additionalTransactionType);
        if (tt == null) {
            throw new SQLException("Unable to find TransactionType: " + this.additionalTransactionType);
        }
        return tt;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PACKAGE_DEFINITION_LIMITS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt("id");
        this.packageDefinition = result.getInt(COLUMN_PACKAGE_DEFINITION_name);
        this.resource = result.getString(COLUMN_RESOURCE_name);
        this.softLimit = result.getInt("soft_limit");
        if (result.wasNull()) {
            this.softLimit = -1;
        }
        this.hardLimit = result.getInt("hard_limit");
        if (result.wasNull()) {
            this.hardLimit = -1;
        }
        this.additionalRate = MoneyUtil.getMoney(result, "additionalRate.currency", "additionalRate.value");
        this.additionalTransactionType = result.getString("additional_transaction_type");
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.packageDefinition = in.readCompressedInt();
        this.resource = in.readUTF().intern();
        this.softLimit = in.readCompressedInt();
        this.hardLimit = in.readCompressedInt();
        this.additionalRate = MoneyUtil.readNullMoney(in);
        this.additionalTransactionType = InternUtils.intern((String)in.readNullUTF());
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.packageDefinition);
        out.writeUTF(this.resource);
        out.writeCompressedInt(this.softLimit);
        out.writeCompressedInt(this.hardLimit);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            if (this.additionalRate != null && this.additionalRate.getCurrency() == Currency.USD && this.additionalRate.getScale() == 2) {
                out.writeCompressedInt(SafeMath.castInt((long)this.additionalRate.getUnscaledValue()));
            } else {
                out.writeCompressedInt(-1);
            }
        } else {
            MoneyUtil.writeNullMoney(this.additionalRate, out);
        }
        out.writeNullUTF(this.additionalTransactionType);
    }
}

