/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.billing.PackageDefinitionLimit;
import com.aoindustries.aoserv.client.billing.Resource;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class PackageDefinitionLimitTable
extends CachedTableIntegerKey<PackageDefinitionLimit> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("package_definition.accounting", true), new AoservTable.OrderBy("package_definition.category", true), new AoservTable.OrderBy("package_definition.monthlyRate", true), new AoservTable.OrderBy("package_definition.name", true), new AoservTable.OrderBy("package_definition.version", true), new AoservTable.OrderBy("resource.name", true)};

    PackageDefinitionLimitTable(AoservConnector connector) {
        super(connector, PackageDefinitionLimit.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    List<PackageDefinitionLimit> getPackageDefinitionLimits(PackageDefinition packageDefinition) throws IOException, SQLException {
        return this.getIndexedRows(1, packageDefinition.getPkey());
    }

    @Override
    public PackageDefinitionLimit get(int pkey) throws IOException, SQLException {
        return (PackageDefinitionLimit)this.getUniqueRow(0, pkey);
    }

    PackageDefinitionLimit getPackageDefinitionLimit(PackageDefinition packageDefinition, Resource resource) throws IOException, SQLException {
        if (packageDefinition == null) {
            throw new AssertionError((Object)"packageDefinition is null");
        }
        if (resource == null) {
            throw new AssertionError((Object)"resource is null");
        }
        String resourceName = resource.getName();
        for (PackageDefinitionLimit limit : this.getPackageDefinitionLimits(packageDefinition)) {
            if (!limit.getResource_name().equals(resourceName)) continue;
            return limit;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PACKAGE_DEFINITION_LIMITS;
    }
}

