/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Money;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.MoneyUtil;
import com.aoindustries.aoserv.client.billing.PackageCategory;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class PackageDefinitionTable
extends CachedTableIntegerKey<PackageDefinition> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("accounting", true), new AoservTable.OrderBy("category", true), new AoservTable.OrderBy("monthlyRate", true), new AoservTable.OrderBy("name", true), new AoservTable.OrderBy("version", true)};

    PackageDefinitionTable(AoservConnector connector) {
        super(connector, PackageDefinition.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addPackageDefinition(final Account business, final PackageCategory category, final String name, final String version, final String display, final String description, final Money setupFee, final TransactionType setupFeeTransactionType, final Money monthlyRate, final TransactionType monthlyRateTransactionType) throws IOException, SQLException {
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.PACKAGE_DEFINITIONS.ordinal());
                out.writeUTF(business.getName().toString());
                out.writeUTF(category.getName());
                out.writeUTF(name);
                out.writeUTF(version);
                out.writeUTF(display);
                out.writeUTF(description);
                MoneyUtil.writeNullMoney(setupFee, out);
                out.writeNullUTF(setupFeeTransactionType == null ? null : setupFeeTransactionType.getName());
                MoneyUtil.writeMoney(monthlyRate, out);
                out.writeUTF(monthlyRateTransactionType.getName());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                PackageDefinitionTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public PackageDefinition get(int pkey) throws IOException, SQLException {
        return (PackageDefinition)this.getUniqueRow(0, pkey);
    }

    public PackageDefinition getPackageDefinition(Account business, PackageCategory category, String name, String version) throws IOException, SQLException {
        Account.Name accounting = business.getName();
        String categoryName = category.getName();
        List pds = this.getRows();
        int size = pds.size();
        for (int c = 0; c < size; ++c) {
            PackageDefinition pd = (PackageDefinition)pds.get(c);
            if (!pd.getAccount_name().equals(accounting) || !pd.getPackageCategory_name().equals(categoryName) || !pd.getName().equals(name) || !pd.getVersion().equals(version)) continue;
            return pd;
        }
        return null;
    }

    public List<PackageDefinition> getPackageDefinitions(Account business, PackageCategory category) throws IOException, SQLException {
        Account.Name accounting = business.getName();
        String categoryName = category.getName();
        List cached = this.getRows();
        ArrayList<PackageDefinition> matches = new ArrayList<PackageDefinition>(cached.size());
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            PackageDefinition pd = (PackageDefinition)cached.get(c);
            if (!pd.getAccount_name().equals(accounting) || !pd.getPackageCategory_name().equals(categoryName)) continue;
            matches.add(pd);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PACKAGE_DEFINITIONS;
    }
}

