/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class PackageTable
extends CachedTableIntegerKey<Package> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true)};

    PackageTable(AoservConnector connector) {
        super(connector, Package.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addPackage(Account.Name name, Account business, PackageDefinition packageDefinition) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.PACKAGES, name, business.getName(), packageDefinition.getPkey()});
    }

    @Override
    @Deprecated
    public Package get(Object pkey) throws IOException, SQLException {
        if (pkey == null) {
            return null;
        }
        if (pkey instanceof Integer) {
            return this.get((Integer)pkey);
        }
        if (pkey instanceof Account.Name) {
            return this.get((Account.Name)pkey);
        }
        throw new IllegalArgumentException("pkey must be either an Integer or an AccountingCode");
    }

    @Override
    public Package get(int pkey) throws IOException, SQLException {
        return (Package)this.getUniqueRow(0, pkey);
    }

    public Package get(Account.Name name) throws IOException, SQLException {
        return (Package)this.getUniqueRow(1, name);
    }

    public Account.Name generatePackageName(Account.Name template) throws IOException, SQLException {
        try {
            return Account.Name.valueOf(this.connector.requestStringQuery(true, AoservProtocol.CommandId.GENERATE_PACKAGE_NAME, template));
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<Package> getPackages(Account business) throws IOException, SQLException {
        return this.getIndexedRows(2, business.getName());
    }

    List<Package> getPackages(PackageDefinition pd) throws IOException, SQLException {
        return this.getIndexedRows(3, pd.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.PACKAGES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_package")) {
            if (Aosh.checkParamCount("add_package", args, 3, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().addPackage(Aosh.parseAccountingCode(args[1], "package"), Aosh.parseAccountingCode(args[2], "business"), Aosh.parseInt(args[3], "package_definition")));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: add_package: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_package")) {
            if (Aosh.checkParamCount("disable_package", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disablePackage(Aosh.parseAccountingCode(args[1], "name"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_package")) {
            if (Aosh.checkParamCount("enable_package", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enablePackage(Aosh.parseAccountingCode(args[1], "name"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("generate_package_name")) {
            if (Aosh.checkParamCount("generate_package_name", args, 1, (PrintWriter)err)) {
                out.println((Object)this.connector.getSimpleClient().generatePackageName(Aosh.parseAccountingCode(args[1], "template")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_package_name_available")) {
            if (Aosh.checkParamCount("is_package_name_available", args, 1, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isPackageNameAvailable(Aosh.parseAccountingCode(args[1], "package")));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_package_name_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        return false;
    }

    public boolean isPackageNameAvailable(Account.Name packageName) throws SQLException, IOException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_PACKAGE_NAME_AVAILABLE, packageName);
    }
}

