/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Resources;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;

public final class Resource
extends GlobalObjectStringKey<Resource> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Resource.class);
    static final int COLUMN_NAME = 0;
    static final String COLUMN_NAME_name = "name";
    public static final String AOSERV_DAEMON = "aoserv_daemon";
    public static final String AOSERV_MASTER = "aoserv_master";
    public static final String BANDWIDTH = "bandwidth";
    public static final String CONSULTING = "consulting";
    public static final String DISK = "disk";
    public static final String DISTRIBUTION_SCAN = "distribution_scan";
    public static final String DRUPAL = "drupal";
    public static final String EMAIL = "email";
    public static final String FAILOVER = "failover";
    public static final String HARDWARE_DISK_7200_120 = "hardware_disk_7200_120";
    public static final String HTTPD = "httpd";
    public static final String IP = "ip";
    public static final String JAVAVM = "javavm";
    public static final String JOOMLA = "joomla";
    public static final String MYSQL_REPLICATION = "mysql_replication";
    public static final String RACK = "rack";
    public static final String SERVER_DATABASE = "server_database";
    public static final String SERVER_ENTERPRISE = "server_enterprise";
    public static final String SERVER_P4 = "server_p4";
    public static final String SERVER_SCSI = "server_scsi";
    public static final String SERVER_XEON = "server_xeon";
    public static final String SITE = "site";
    public static final String SYSADMIN = "sysadmin";
    public static final String USER = "user";

    @Deprecated
    public Resource() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getName() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.RESOURCES;
    }

    public String getDisplayUnit(int quantity) {
        if (quantity == 1) {
            return RESOURCES.getMessage(this.pkey + ".singularDisplayUnit", new Object[]{quantity});
        }
        return RESOURCES.getMessage(this.pkey + ".pluralDisplayUnit", new Object[]{quantity});
    }

    public String getPerUnit(Object amount) {
        return RESOURCES.getMessage(this.pkey + ".perUnit", new Object[]{amount});
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
    }

    @Override
    public String toStringImpl() {
        return RESOURCES.getMessage(this.pkey + ".toString");
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_60) <= 0) {
            out.writeUTF(RESOURCES.getMessage(this.pkey + ".singularDisplayUnit", new Object[]{""}));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_123) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_60) <= 0) {
            out.writeUTF(RESOURCES.getMessage(this.pkey + ".pluralDisplayUnit", new Object[]{""}));
            out.writeUTF(this.getPerUnit(""));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_60) <= 0) {
            out.writeUTF(this.toString());
        }
    }
}

