/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.math.SafeMath;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.SQLUtility;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.billing.Currency;
import com.aoindustries.aoserv.client.billing.MoneyUtil;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.payment.Payment;
import com.aoindustries.aoserv.client.payment.PaymentType;
import com.aoindustries.aoserv.client.payment.Processor;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class Transaction
extends CachedObjectIntegerKey<Transaction> {
    static final int COLUMN_TRANSID = 1;
    static final int COLUMN_ACCOUNTING = 2;
    static final int COLUMN_SOURCE_ACCOUNTING = 3;
    static final int COLUMN_ADMINISTRATOR = 4;
    static final String COLUMN_TIME_name = "time";
    static final String COLUMN_TRANSID_name = "transid";
    static final String COLUMN_SOURCE_ACCOUNTING_name = "source_accounting";
    public static final int UNASSIGNED = -1;
    private UnmodifiableTimestamp time;
    private Account.Name accounting;
    private Account.Name sourceAccounting;
    private User.Name username;
    private String type;
    private String description;
    private int quantity;
    private Money rate;
    private String paymentType;
    private String paymentInfo;
    private String processor;
    private int creditCardTransaction;
    public static final byte WAITING_CONFIRMATION = 0;
    public static final byte CONFIRMED = 1;
    public static final byte NOT_CONFIRMED = 2;
    private static final String[] paymentConfirmedLabels = new String[]{"Pending", "Confirmed", "Failed"};
    public static final int NUM_PAYMENT_CONFIRMATION_STATES = 3;
    private byte paymentConfirmed;

    @Deprecated
    public Transaction() {
    }

    public void approved(final int creditCardTransaction, final String paymentInfo) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.TRANSACTION_APPROVED, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Transaction.this.pkey);
                out.writeCompressedInt(creditCardTransaction);
                out.writeNullUTF(paymentInfo);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Transaction.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    @Deprecated
    public void approved(int creditCardTransaction) throws IOException, SQLException {
        this.approved(creditCardTransaction, null);
    }

    public void declined(final int creditCardTransaction, final String paymentInfo) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.TRANSACTION_DECLINED, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Transaction.this.pkey);
                out.writeCompressedInt(creditCardTransaction);
                out.writeNullUTF(paymentInfo);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Transaction.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    @Deprecated
    public void declined(int creditCardTransaction) throws IOException, SQLException {
        this.declined(creditCardTransaction, null);
    }

    public void held(final int creditCardTransaction, final String paymentInfo) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.TRANSACTION_HELD, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Transaction.this.pkey);
                out.writeCompressedInt(creditCardTransaction);
                out.writeNullUTF(paymentInfo);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Transaction.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    @Deprecated
    public void held(int creditCardTransaction) throws IOException, SQLException {
        this.held(creditCardTransaction, null);
    }

    @Deprecated
    public String getAprNum() throws SQLException, IOException {
        Payment cct = this.getPayment();
        return cct == null ? null : cct.getAuthorizationApprovalCode();
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        Account business = this.table.getConnector().getAccount().getAccount().get(this.accounting);
        if (business == null) {
            throw new SQLException("Unable to find Account: " + this.accounting);
        }
        return business;
    }

    public Account.Name getSourceAccount_name() {
        return this.sourceAccounting;
    }

    public Account getSourceAccount() throws SQLException, IOException {
        Account business = this.table.getConnector().getAccount().getAccount().get(this.sourceAccounting);
        if (business == null) {
            throw new SQLException("Unable to find Account: " + this.sourceAccounting);
        }
        return business;
    }

    public User.Name getAdministrator_username() {
        return this.username;
    }

    public Administrator getAdministrator() throws SQLException, IOException {
        User un = this.table.getConnector().getAccount().getUser().get(this.username);
        if (un == null) {
            return null;
        }
        Administrator administrator = un.getAdministrator();
        if (administrator == null) {
            throw new SQLException("Unable to find Administrator: " + this.username);
        }
        return administrator;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.time;
            }
            case 1: {
                return this.pkey;
            }
            case 2: {
                return this.accounting;
            }
            case 3: {
                return this.sourceAccounting;
            }
            case 4: {
                return this.username;
            }
            case 5: {
                return this.type;
            }
            case 6: {
                return this.description;
            }
            case 7: {
                return this.quantity;
            }
            case 8: {
                return this.rate;
            }
            case 9: {
                return this.paymentType;
            }
            case 10: {
                return this.paymentInfo;
            }
            case 11: {
                return this.processor;
            }
            case 12: {
                return this.getPayment_id();
            }
            case 13: {
                return this.paymentConfirmed == 1 ? "Y" : (this.paymentConfirmed == 2 ? "N" : "W");
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getDescription() {
        return this.description;
    }

    public String getProcessor_providerId() {
        return this.processor;
    }

    public Processor getProcessor() throws SQLException, IOException {
        if (this.processor == null) {
            return null;
        }
        Processor creditCardProcessor = this.table.getConnector().getPayment().getProcessor().get(this.processor);
        if (creditCardProcessor == null) {
            throw new SQLException("Unable to find CreditCardProcessor: " + this.processor);
        }
        return creditCardProcessor;
    }

    public Integer getPayment_id() {
        return this.creditCardTransaction == -1 ? null : Integer.valueOf(this.creditCardTransaction);
    }

    public Payment getPayment() throws SQLException, IOException {
        if (this.creditCardTransaction == -1) {
            return null;
        }
        Payment cct = this.table.getConnector().getPayment().getPayment().get(this.creditCardTransaction);
        if (cct == null) {
            throw new SQLException("Unable to find CreditCardTransaction: " + this.creditCardTransaction);
        }
        return cct;
    }

    public byte getPaymentConfirmed() {
        return this.paymentConfirmed;
    }

    public static String getPaymentConfirmedLabel(int index) {
        return paymentConfirmedLabels[index];
    }

    public String getPaymentInfo() {
        return this.paymentInfo;
    }

    public String getPaymentType_name() {
        return this.paymentType;
    }

    public PaymentType getPaymentType() throws SQLException, IOException {
        if (this.paymentType == null) {
            return null;
        }
        PaymentType paymentType = this.table.getConnector().getPayment().getPaymentType().get(this.paymentType);
        if (paymentType == null) {
            throw new SQLException("Unable to find PaymentType: " + this.paymentType);
        }
        return paymentType;
    }

    public Money getAmount() {
        return this.rate.multiply(BigDecimal.valueOf(this.quantity, 3), RoundingMode.HALF_UP);
    }

    public int getQuantity() {
        return this.quantity;
    }

    public Money getRate() {
        return this.rate;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TRANSACTIONS;
    }

    public UnmodifiableTimestamp getTime() {
        return this.time;
    }

    public int getTransid() {
        return this.pkey;
    }

    public String getType_name() {
        return this.type;
    }

    public TransactionType getType() throws SQLException, IOException {
        TransactionType tt = this.table.getConnector().getBilling().getTransactionType().get(this.type);
        if (tt == null) {
            throw new SQLException("Unable to find TransactionType: " + this.type);
        }
        return tt;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        block6: {
            try {
                String typeString;
                this.time = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(COLUMN_TIME_name));
                this.pkey = result.getInt(COLUMN_TRANSID_name);
                this.accounting = Account.Name.valueOf(result.getString("accounting"));
                this.sourceAccounting = Account.Name.valueOf(result.getString(COLUMN_SOURCE_ACCOUNTING_name));
                this.username = User.Name.valueOf(result.getString("username"));
                this.type = result.getString("type");
                this.description = result.getString("description");
                this.quantity = SQLUtility.parseDecimal3((String)result.getString("quantity"));
                this.rate = MoneyUtil.getMoney(result, "rate.currency", "rate.value");
                this.paymentType = result.getString("payment_type");
                this.paymentInfo = result.getString("payment_info");
                this.processor = result.getString("processor");
                this.creditCardTransaction = result.getInt("credit_card_transaction");
                if (result.wasNull()) {
                    this.creditCardTransaction = -1;
                }
                if ("Y".equals(typeString = result.getString("payment_confirmed"))) {
                    this.paymentConfirmed = 1;
                    break block6;
                }
                if ("N".equals(typeString)) {
                    this.paymentConfirmed = (byte)2;
                    break block6;
                }
                if ("W".equals(typeString)) {
                    this.paymentConfirmed = 0;
                    break block6;
                }
                throw new SQLException("Unknown payment_confirmed '" + typeString + "' for transid=" + this.pkey);
            }
            catch (ValidationException e) {
                throw new SQLException(e);
            }
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.time = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.pkey = in.readCompressedInt();
            this.accounting = Account.Name.valueOf(in.readCompressedUTF()).intern();
            this.sourceAccounting = Account.Name.valueOf(in.readCompressedUTF()).intern();
            this.username = User.Name.valueOf(in.readCompressedUTF()).intern();
            this.type = in.readCompressedUTF().intern();
            this.description = in.readCompressedUTF();
            this.quantity = in.readCompressedInt();
            this.rate = MoneyUtil.readMoney(in);
            this.paymentType = InternUtils.intern((String)in.readNullUTF());
            this.paymentInfo = in.readNullUTF();
            this.processor = InternUtils.intern((String)in.readNullUTF());
            this.creditCardTransaction = in.readCompressedInt();
            this.paymentConfirmed = in.readByte();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.pkey + "|" + this.accounting + '|' + this.sourceAccounting + '|' + this.type + '|' + SQLUtility.formatDecimal3((int)this.quantity) + '\u00d7' + this.rate + '|' + (char)(this.paymentConfirmed == 1 ? 89 : (this.paymentConfirmed == 2 ? 78 : 87));
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.time.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.time, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.pkey);
        out.writeCompressedUTF(this.accounting.toString(), 0);
        out.writeCompressedUTF(this.sourceAccounting.toString(), 1);
        out.writeCompressedUTF(this.username.toString(), 2);
        out.writeCompressedUTF(this.type, 3);
        out.writeCompressedUTF(this.description, 4);
        out.writeCompressedInt(this.quantity);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            if (this.rate != null && this.rate.getCurrency() == Currency.USD && this.rate.getScale() == 2) {
                out.writeCompressedInt(SafeMath.castInt((long)this.rate.getUnscaledValue()));
            } else {
                out.writeCompressedInt(-1);
            }
        } else {
            MoneyUtil.writeMoney(this.rate, out);
        }
        out.writeNullUTF(this.paymentType);
        out.writeNullUTF(this.paymentInfo);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_29) < 0) {
            out.writeNullUTF(null);
        } else {
            out.writeNullUTF(this.processor);
            out.writeCompressedInt(this.creditCardTransaction);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_128) < 0) {
            out.writeCompressedInt(-1);
        } else if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_29) < 0) {
            out.writeNullUTF(null);
        }
        out.writeByte((int)this.paymentConfirmed);
    }

    static {
        assert (paymentConfirmedLabels.length == 3);
    }
}

