/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservStreamable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.billing.Transaction;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.payment.PaymentType;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Type;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;

public final class TransactionSearchCriteria
implements AoservStreamable {
    public static final int ANY = -1;
    private UnmodifiableTimestamp after;
    private UnmodifiableTimestamp before;
    private int transid;
    private Account.Name account;
    private Account.Name sourceAccount;
    private User.Name administrator;
    private String type;
    private String description;
    private String paymentType;
    private String paymentInfo;
    private byte paymentConfirmed;

    @Deprecated
    public TransactionSearchCriteria() {
    }

    public TransactionSearchCriteria(Timestamp after, Timestamp before, int transid, Account.Name account, Account.Name sourceAccount, User.Name administrator, String type, String description, String paymentType, String paymentInfo, byte paymentConfirmed) {
        this.after = UnmodifiableTimestamp.valueOf((Timestamp)after);
        this.before = UnmodifiableTimestamp.valueOf((Timestamp)before);
        this.transid = transid;
        this.account = account;
        this.sourceAccount = sourceAccount;
        this.administrator = administrator;
        this.type = type;
        this.description = description;
        this.paymentType = paymentType;
        this.paymentInfo = paymentInfo;
        this.paymentConfirmed = paymentConfirmed;
    }

    public TransactionSearchCriteria(Timestamp after, Timestamp before, int transid, Account account, Account sourceAccount, Administrator administrator, TransactionType type, String description, PaymentType paymentType, String paymentInfo, byte paymentConfirmed) {
        this(after, before, transid, account == null ? null : account.getName(), sourceAccount == null ? null : sourceAccount.getName(), administrator == null ? null : administrator.getUsername_userId(), type == null ? null : type.getName(), description, paymentType == null ? null : paymentType.getName(), paymentInfo, paymentConfirmed);
    }

    public static UnmodifiableTimestamp getDefaultAfter(long time) {
        GregorianCalendar gcal = new GregorianCalendar(Type.DATE_TIME_ZONE);
        gcal.setTimeInMillis(time);
        int year = gcal.get(1);
        int month = gcal.get(2);
        if (month == 0) {
            --year;
            month = 11;
        } else {
            --month;
        }
        gcal.set(1, year);
        gcal.set(2, month);
        gcal.set(5, 1);
        gcal.set(11, 0);
        gcal.set(12, 0);
        gcal.set(13, 0);
        gcal.set(14, 0);
        return new UnmodifiableTimestamp(gcal.getTimeInMillis());
    }

    public TransactionSearchCriteria(Administrator administrator) throws IOException, SQLException {
        this.before = null;
        this.after = TransactionSearchCriteria.getDefaultAfter(System.currentTimeMillis());
        this.transid = -1;
        this.account = administrator == null ? null : administrator.getUsername().getPackage().getAccount_name();
        this.sourceAccount = null;
        this.administrator = null;
        this.type = null;
        this.description = null;
        this.paymentType = null;
        this.paymentInfo = null;
        this.paymentConfirmed = (byte)-1;
    }

    public UnmodifiableTimestamp getAfter() {
        return this.after;
    }

    public UnmodifiableTimestamp getBefore() {
        return this.before;
    }

    public Account.Name getAccount() {
        return this.account;
    }

    public Account.Name getSourceAccount() {
        return this.sourceAccount;
    }

    public User.Name getAdministrator() {
        return this.administrator;
    }

    public String getDescription() {
        return this.description;
    }

    public byte getPaymentConfirmed() {
        return this.paymentConfirmed;
    }

    public String getPaymentInfo() {
        return this.paymentInfo;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public String getType() {
        return this.type;
    }

    @Deprecated
    public List<Transaction> getTransactions(AoservConnector connector) throws IOException, SQLException {
        return connector.getBilling().getTransaction().get(this);
    }

    public int getTransid() {
        return this.transid;
    }

    @Override
    @Deprecated
    public void read(StreamableInput in, String protocolVersion) throws IOException {
        this.read(in, AoservProtocol.Version.getVersion(protocolVersion));
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
                long l = in.readLong();
                this.after = l == -1L ? null : new UnmodifiableTimestamp(l);
                l = in.readLong();
                this.before = l == -1L ? null : new UnmodifiableTimestamp(l);
            } else {
                this.after = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
                this.before = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            }
            this.transid = in.readCompressedInt();
            this.account = (Account.Name)InternUtils.intern((Internable)Account.Name.valueOf(in.readNullUTF()));
            this.sourceAccount = (Account.Name)InternUtils.intern((Internable)Account.Name.valueOf(in.readNullUTF()));
            this.administrator = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.type = InternUtils.intern((String)in.readNullUTF());
            this.description = in.readNullUTF();
            this.paymentType = InternUtils.intern((String)in.readNullUTF());
            this.paymentInfo = in.readNullUTF();
            this.paymentConfirmed = in.readByte();
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
                in.readByte();
                in.readByte();
                in.readBoolean();
            }
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public void setAfter(Timestamp after) {
        this.after = UnmodifiableTimestamp.valueOf((Timestamp)after);
    }

    public void setBefore(Timestamp before) {
        this.before = UnmodifiableTimestamp.valueOf((Timestamp)before);
    }

    public void setAccount(Account.Name account) {
        this.account = account;
    }

    public void setSourceAccount(Account.Name sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public void setAdministrator(User.Name administrator) {
        this.administrator = administrator;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPaymentConfirmed(byte paymentConfirmed) {
        this.paymentConfirmed = paymentConfirmed;
    }

    public void setPaymentInfo(String paymentInfo) {
        this.paymentInfo = paymentInfo;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTransid(int transid) {
        this.transid = transid;
    }

    @Override
    @Deprecated
    public void write(StreamableOutput out, String protocolVersion) throws IOException {
        this.write(out, AoservProtocol.Version.getVersion(protocolVersion));
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.after == null ? -1L : this.after.getTime());
            out.writeLong(this.before == null ? -1L : this.before.getTime());
        } else {
            SQLStreamables.writeNullTimestamp((Timestamp)this.after, (DataOutputStream)out);
            SQLStreamables.writeNullTimestamp((Timestamp)this.before, (DataOutputStream)out);
        }
        out.writeCompressedInt(this.transid);
        out.writeNullUTF(Objects.toString(this.account, null));
        out.writeNullUTF(Objects.toString(this.sourceAccount, null));
        out.writeNullUTF(Objects.toString(this.administrator, null));
        out.writeNullUTF(this.type);
        out.writeNullUTF(this.description);
        out.writeNullUTF(this.paymentType);
        out.writeNullUTF(this.paymentInfo);
        out.writeByte((int)this.paymentConfirmed);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeByte(0);
            out.writeByte(0);
            out.writeBoolean(true);
        }
    }
}

