/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.collections.IntList;
import com.aoapps.collections.MinimalList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.i18n.CurrencyComparator;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.i18n.Monies;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.SQLUtility;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.MoneyUtil;
import com.aoindustries.aoserv.client.billing.Transaction;
import com.aoindustries.aoserv.client.billing.TransactionSearchCriteria;
import com.aoindustries.aoserv.client.billing.TransactionType;
import com.aoindustries.aoserv.client.payment.PaymentType;
import com.aoindustries.aoserv.client.payment.Processor;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;

public final class TransactionTable
extends CachedTableIntegerKey<Transaction> {
    private final Map<Account.Name, Monies> accountBalances = new HashMap<Account.Name, Monies>();
    private final Map<Account.Name, Monies> confirmedAccountBalances = new HashMap<Account.Name, Monies>();
    private final Map<Transaction, Monies> transactionBalances = new HashMap<Transaction, Monies>();
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("time::date", true), new AoservTable.OrderBy("source_accounting", true), new AoservTable.OrderBy("time", true), new AoservTable.OrderBy("transid", true)};
    private static final long SHOW_CANCELED_DURATION = 31622400000L;

    TransactionTable(AoservConnector connector) {
        super(connector, Transaction.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int add(final int timeType, final Timestamp time, final Account account, final Account sourceAccount, final Administrator administrator, final TransactionType type, final String description, final int quantity, final Money rate, final PaymentType paymentType, final String paymentInfo, final Processor processor, final byte paymentConfirmed) throws IOException, SQLException {
        if (timeType != 5 && timeType != 26) {
            throw new IllegalArgumentException("timeType must be either Type.DATE or Type.TIME: " + timeType);
        }
        return this.connector.requestResult(false, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int transid;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.TRANSACTIONS.ordinal());
                if (timeType == 5) {
                    out.writeByte(68);
                    out.writeNullLong(time == null ? null : Long.valueOf(time.getTime()));
                } else if (timeType == 26) {
                    out.writeByte(84);
                    SQLStreamables.writeNullTimestamp((Timestamp)time, (DataOutputStream)out);
                } else {
                    throw new AssertionError((Object)("Unexpected value for timeType: " + timeType));
                }
                out.writeUTF(account.getName().toString());
                out.writeUTF(sourceAccount.getName().toString());
                out.writeUTF(administrator.getUsername_userId().toString());
                out.writeUTF(type.getName());
                out.writeUTF(description);
                out.writeCompressedInt(quantity);
                MoneyUtil.writeMoney(rate, out);
                out.writeBoolean(paymentType != null);
                if (paymentType != null) {
                    out.writeUTF(paymentType.getName());
                }
                out.writeNullUTF(paymentInfo);
                out.writeNullUTF(processor == null ? null : processor.getProviderId());
                out.writeByte((int)paymentConfirmed);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.transid = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                TransactionTable.this.connector.tablesUpdated(this.invalidateList);
                return this.transid;
            }
        });
    }

    @Override
    public Transaction get(int transid) throws IOException, SQLException {
        return (Transaction)this.getUniqueRow(1, transid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Map<Object, Monies> map = this.accountBalances;
        synchronized (map) {
            this.accountBalances.clear();
        }
        map = this.confirmedAccountBalances;
        synchronized (map) {
            this.confirmedAccountBalances.clear();
        }
        map = this.transactionBalances;
        synchronized (map) {
            this.transactionBalances.clear();
        }
    }

    private static void addBalance(SortedMap<Currency, BigDecimal> accountBalances, Money amount) {
        Currency currency = amount.getCurrency();
        BigDecimal total = (BigDecimal)accountBalances.get(currency);
        total = total == null ? amount.getValue() : total.add(amount.getValue());
        accountBalances.put(currency, total);
    }

    private static void addAccountBalance(Map<Account.Name, SortedMap<Currency, BigDecimal>> balances, Account.Name account, Money amount) {
        SortedMap<Currency, BigDecimal> accountBalances = balances.get(account);
        if (accountBalances == null) {
            accountBalances = new TreeMap<Currency, BigDecimal>((Comparator<Currency>)CurrencyComparator.getInstance());
            balances.put(account, accountBalances);
        }
        TransactionTable.addBalance(accountBalances, amount);
    }

    private static Monies toMonies(SortedMap<Currency, BigDecimal> balances) {
        List monies = MinimalList.emptyList();
        for (Map.Entry<Currency, BigDecimal> moneyEntry : balances.entrySet()) {
            monies = MinimalList.add((List)monies, (Object)new Money(moneyEntry.getKey(), moneyEntry.getValue()));
        }
        return Monies.of((Iterable)monies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monies getAccountBalance(Account account) throws IOException, SQLException {
        if (account == null) {
            return Monies.of();
        }
        Map<Account.Name, Monies> map = this.accountBalances;
        synchronized (map) {
            Monies balance;
            if (this.accountBalances.isEmpty()) {
                HashMap<Account.Name, SortedMap<Currency, BigDecimal>> balances = new HashMap<Account.Name, SortedMap<Currency, BigDecimal>>();
                for (Transaction transaction : this.getRows()) {
                    if (transaction.getPaymentConfirmed() == 2) continue;
                    TransactionTable.addAccountBalance(balances, transaction.getAccount_name(), transaction.getAmount());
                }
                for (Map.Entry entry : balances.entrySet()) {
                    this.accountBalances.put((Account.Name)entry.getKey(), TransactionTable.toMonies((SortedMap)entry.getValue()));
                }
            }
            Monies monies = (balance = this.accountBalances.get(account.getName())) == null ? Monies.of() : balance;
            return monies;
        }
    }

    public Monies getActiveAccountBalance(Account account, long currentTime) throws IOException, SQLException {
        Monies monthlyRate;
        if (account == null) {
            return Monies.of();
        }
        UnmodifiableTimestamp canceled = account.getCanceled();
        Monies accountBalance = this.getAccountBalance(account);
        if (canceled == null) {
            monthlyRate = account.getBillingMonthlyRate();
            for (Currency currency : monthlyRate.getCurrencies()) {
                accountBalance = accountBalance.add(new Money(currency, 0L, 0));
            }
        } else {
            monthlyRate = Monies.of();
        }
        List<Transaction> transactions = null;
        int numTransactions = 0;
        Monies activeAccountBalance = Monies.of();
        for (Money money : accountBalance) {
            boolean active;
            if (monthlyRate.getCurrencies().contains(money.getCurrency())) {
                active = true;
            } else if (canceled == null || currentTime - canceled.getTime() <= 31622400000L || money.getUnscaledValue() != 0L) {
                active = true;
            } else {
                if (transactions == null) {
                    transactions = this.getTransactions(account);
                    numTransactions = transactions.size();
                }
                Transaction lastTransaction = null;
                for (int i = numTransactions - 1; i >= 0; --i) {
                    Transaction transaction = transactions.get(i);
                    if (transaction.getPaymentConfirmed() == 2 || transaction.getRate().getCurrency() != money.getCurrency()) continue;
                    lastTransaction = transaction;
                    break;
                }
                boolean bl = active = lastTransaction != null && currentTime - lastTransaction.getTime().getTime() <= 31622400000L;
            }
            if (!active) continue;
            activeAccountBalance = activeAccountBalance.add(money);
        }
        return activeAccountBalance;
    }

    public Monies getActiveAccountBalance(Account account) throws IOException, SQLException {
        return this.getActiveAccountBalance(account, System.currentTimeMillis());
    }

    public Monies getAccountBalance(Account account, Timestamp before) throws IOException, SQLException {
        if (account == null) {
            return Monies.of();
        }
        TreeMap<Currency, BigDecimal> balances = new TreeMap<Currency, BigDecimal>((Comparator<Currency>)CurrencyComparator.getInstance());
        for (Transaction transaction : this.getTransactions(account)) {
            if (transaction.getPaymentConfirmed() == 2 || transaction.getTime().compareTo(before) >= 0) continue;
            TransactionTable.addBalance(balances, transaction.getAmount());
        }
        return TransactionTable.toMonies(balances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monies getConfirmedAccountBalance(Account account) throws IOException, SQLException {
        if (account == null) {
            return Monies.of();
        }
        Map<Account.Name, Monies> map = this.confirmedAccountBalances;
        synchronized (map) {
            Monies balance;
            if (this.confirmedAccountBalances.isEmpty()) {
                HashMap<Account.Name, SortedMap<Currency, BigDecimal>> balances = new HashMap<Account.Name, SortedMap<Currency, BigDecimal>>();
                for (Transaction transaction : this.getRows()) {
                    if (transaction.getPaymentConfirmed() != 1) continue;
                    TransactionTable.addAccountBalance(balances, transaction.getAccount_name(), transaction.getAmount());
                }
                for (Map.Entry entry : balances.entrySet()) {
                    this.confirmedAccountBalances.put((Account.Name)entry.getKey(), TransactionTable.toMonies((SortedMap)entry.getValue()));
                }
            }
            Monies monies = (balance = this.confirmedAccountBalances.get(account.getName())) == null ? Monies.of() : balance;
            return monies;
        }
    }

    public Monies getConfirmedAccountBalance(Account account, Timestamp before) throws IOException, SQLException {
        if (account == null) {
            return Monies.of();
        }
        TreeMap<Currency, BigDecimal> balances = new TreeMap<Currency, BigDecimal>((Comparator<Currency>)CurrencyComparator.getInstance());
        for (Transaction transaction : this.getTransactions(account)) {
            if (transaction.getPaymentConfirmed() != 1 || transaction.getTime().compareTo(before) >= 0) continue;
            TransactionTable.addBalance(balances, transaction.getAmount());
        }
        return TransactionTable.toMonies(balances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monies getTransactionBalance(Transaction transaction) throws IOException, SQLException {
        Map<Transaction, Monies> map = this.transactionBalances;
        synchronized (map) {
            Monies balance;
            if (this.transactionBalances.isEmpty()) {
                HashMap<Account.Name, Monies> accountBalance = new HashMap<Account.Name, Monies>();
                for (Transaction trans : this.getRows()) {
                    Account.Name account = trans.getAccount_name();
                    Monies balance2 = (Monies)accountBalance.get(account);
                    boolean updated = false;
                    if (balance2 == null) {
                        balance2 = Monies.of();
                        updated = true;
                    }
                    if (trans.getPaymentConfirmed() != 2) {
                        balance2 = balance2.add(trans.getAmount());
                        updated = true;
                    }
                    if (updated) {
                        accountBalance.put(account, balance2);
                    }
                    this.transactionBalances.put(trans, balance2);
                }
            }
            if ((balance = this.transactionBalances.get(transaction)) == null) {
                throw new SQLException("Unable to find transaction in transactionBalances: " + transaction);
            }
            return balance;
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TRANSACTIONS;
    }

    private static boolean matchesWords(String value, String words) {
        String lower = value == null ? null : value.toLowerCase(Locale.ROOT);
        for (String word : Strings.split((String)words)) {
            if (lower != null && lower.contains(word.toLowerCase(Locale.ROOT))) continue;
            return false;
        }
        return true;
    }

    public List<Transaction> get(TransactionSearchCriteria criteria) throws IOException, SQLException {
        List<Object> rows;
        ArrayList<Transaction> matches = new ArrayList<Transaction>();
        if (criteria.getTransid() == -1) {
            rows = this.getRows();
        } else {
            Transaction row = this.get(criteria.getTransid());
            if (row == null) {
                return Collections.emptyList();
            }
            rows = Collections.singletonList(row);
        }
        for (Transaction tr : rows) {
            if (criteria.getAfter() != null && tr.getTime().compareTo((Timestamp)criteria.getAfter()) < 0 || criteria.getBefore() != null && tr.getTime().compareTo((Timestamp)criteria.getBefore()) >= 0 || criteria.getPaymentConfirmed() != -1 && criteria.getPaymentConfirmed() != tr.getPaymentConfirmed() || criteria.getAccount() != null && !criteria.getAccount().equals(tr.getAccount_name()) || criteria.getSourceAccount() != null && !criteria.getSourceAccount().equals(tr.getSourceAccount_name()) || criteria.getAdministrator() != null && !criteria.getAdministrator().equals(tr.getAdministrator_username()) || criteria.getType() != null && !criteria.getType().equals(tr.getType_name()) || criteria.getDescription() != null && !criteria.getDescription().isEmpty() && !TransactionTable.matchesWords(tr.getDescription(), criteria.getDescription()) || criteria.getPaymentType() != null && !criteria.getPaymentType().equals(tr.getPaymentType_name()) || criteria.getPaymentInfo() != null && !criteria.getPaymentInfo().isEmpty() && !TransactionTable.matchesWords(tr.getPaymentInfo(), criteria.getPaymentInfo())) continue;
            matches.add(tr);
        }
        return Collections.unmodifiableList(matches);
    }

    public List<Transaction> getTransactions(Account account) throws IOException, SQLException {
        return this.getIndexedRows(2, account == null ? null : account.getName());
    }

    public List<Transaction> getTransactionsFrom(Account account) throws IOException, SQLException {
        return this.getIndexedRows(3, account == null ? null : account.getName());
    }

    public List<Transaction> getTransactions(Administrator ba) throws IOException, SQLException {
        return this.getIndexedRows(4, ba == null ? null : ba.getUsername_userId());
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("billing.Transaction.add")) {
            if (Aosh.checkParamCount("billing.Transaction.add", args, 13, (PrintWriter)err)) {
                Timestamp time;
                int timeType;
                byte pc;
                String paymentConfirmed = args[13];
                if ("Confirmed".equals(paymentConfirmed) || "Y".equals(paymentConfirmed)) {
                    pc = 1;
                } else if ("Pending".equals(paymentConfirmed) || "W".equals(paymentConfirmed)) {
                    pc = 0;
                } else if ("Failed".equals(paymentConfirmed) || "N".equals(paymentConfirmed)) {
                    pc = 2;
                } else {
                    throw new IllegalArgumentException("Unknown value for payment_confirmed, should be one of \"Pending\", \"Confirmed\", or \"Failed\": " + paymentConfirmed);
                }
                String timeStr = args[1];
                if ("now".equalsIgnoreCase(timeStr)) {
                    timeType = 26;
                    time = null;
                } else if ("today".equalsIgnoreCase(timeStr)) {
                    timeType = 5;
                    time = null;
                } else if (timeStr.length() <= "YYYY-MM-DD".length()) {
                    timeType = 5;
                    time = SQLUtility.parseDateTime((String)timeStr, (TimeZone)Type.DATE_TIME_ZONE);
                } else {
                    timeType = 26;
                    time = SQLUtility.parseDateTime((String)timeStr);
                }
                out.println(this.connector.getSimpleClient().addTransaction(timeType, time, Aosh.parseAccountingCode(args[2], "business"), Aosh.parseAccountingCode(args[3], "source_business"), Aosh.parseUserName(args[4], "business_administrator"), args[5], args[6], Aosh.parseDecimal3(args[7], "quantity"), new Money(Currency.getInstance(args[8]), Aosh.parseBigDecimal(args[9], "rate")), args[10], args[11], args[12], pc));
                out.flush();
            }
            return true;
        }
        return false;
    }
}

