/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Resources;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;

public final class TransactionType
extends GlobalObjectStringKey<TransactionType> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, TransactionType.class);
    static final int COLUMN_NAME = 0;
    static final String COLUMN_NAME_name = "name";
    public static final String HTTPD = "httpd";
    public static final String PAYMENT = "payment";
    public static final String VIRTUAL = "virtual";
    private boolean isCredit;

    @Deprecated
    public TransactionType() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.isCredit;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getDescription() {
        return RESOURCES.getMessage(this.pkey + ".description");
    }

    public String getName() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TRANSACTION_TYPES;
    }

    public String getUnit() {
        return RESOURCES.getMessage(this.pkey + ".unit");
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.isCredit = result.getBoolean(2);
    }

    public boolean isCredit() {
        return this.isCredit;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.isCredit = in.readBoolean();
    }

    @Override
    public String toStringImpl() {
        return RESOURCES.getMessage(this.pkey + ".toString");
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_60) <= 0) {
            out.writeUTF(this.toStringImpl());
            out.writeUTF(this.getDescription());
            out.writeUTF(this.getUnit());
        }
        out.writeBoolean(this.isCredit);
    }
}

