/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.billing;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.WhoisHistoryAccount;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public final class WhoisHistory
extends CachedObjectIntegerKey<WhoisHistory> {
    static final int COLUMN_id = 0;
    static final int COLUMN_output = 4;
    static final int COLUMN_error = 5;
    static final String COLUMN_registrableDomain_name = "registrableDomain";
    static final String COLUMN_time_name = "time";
    private DomainName registrableDomain;
    private UnmodifiableTimestamp time;
    private Integer exitStatus;
    private final OutputLock outputLock = new OutputLock();
    private String output;
    private String error;
    private Account.Name accounting;

    @Deprecated
    public WhoisHistory() {
    }

    @Override
    protected Object getColumnImpl(int i) throws IOException, SQLException {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.registrableDomain;
            }
            case 2: {
                return this.time;
            }
            case 3: {
                return this.exitStatus;
            }
            case 4: {
                return this.getOutput();
            }
            case 5: {
                return this.getError();
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public DomainName getRegistrableDomain() {
        return this.registrableDomain;
    }

    public UnmodifiableTimestamp getTime() {
        return this.time;
    }

    public Integer getExitStatus() {
        return this.exitStatus;
    }

    private void loadOutput() throws IOException, SQLException {
        assert (Thread.holdsLock(this.outputLock));
        if (this.error == null) {
            this.table.getConnector().requestResult(true, AoservProtocol.CommandId.GET_WHOIS_HISTORY_WHOIS_OUTPUT, new AoservConnector.ResultRequest<Void>(){

                @Override
                public void writeRequest(StreamableOutput out) throws IOException {
                    out.writeCompressedInt(WhoisHistory.this.pkey);
                }

                @Override
                public void readResponse(StreamableInput in) throws IOException, SQLException {
                    byte code = in.readByte();
                    if (code != 1) {
                        AoservProtocol.checkResult(code, in);
                        throw new IOException("Unexpected response code: " + code);
                    }
                    WhoisHistory.this.output = in.readUTF();
                    WhoisHistory.this.error = in.readUTF();
                }

                @Override
                public Void afterRelease() {
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOutput() throws IOException, SQLException {
        OutputLock outputLock = this.outputLock;
        synchronized (outputLock) {
            this.loadOutput();
            return this.output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getError() throws IOException, SQLException {
        OutputLock outputLock = this.outputLock;
        synchronized (outputLock) {
            this.loadOutput();
            return this.error;
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.WhoisHistory;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.registrableDomain = DomainName.valueOf((String)result.getString(pos++));
            this.time = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.exitStatus = result.getInt(pos++);
            if (result.wasNull()) {
                this.exitStatus = null;
            }
            this.accounting = Account.Name.valueOf(result.getString(pos++));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.registrableDomain = DomainName.valueOf((String)in.readUTF()).intern();
            this.time = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.exitStatus = in.readNullInteger();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_19) >= 0) {
            out.writeUTF(this.registrableDomain.toString());
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.time.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.time, (DataOutputStream)out);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_19) < 0) {
            out.writeUTF(this.accounting.toString());
            out.writeUTF(this.registrableDomain.toString() + ".");
        } else {
            out.writeNullInteger(this.exitStatus);
        }
    }

    @Override
    public String toStringImpl() {
        return this.pkey + "|" + this.registrableDomain + "|" + this.getTime();
    }

    public List<WhoisHistoryAccount> getAccounts() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getWhoisHistoryAccount().getWhoisHistoryAccounts(this);
    }

    private static class OutputLock {
        private OutputLock() {
        }
    }
}

