/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.distribution.Architecture;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class OperatingSystem
extends GlobalObjectStringKey<OperatingSystem> {
    static final int COLUMN_NAME = 0;
    static final String COLUMN_NAME_name = "name";
    public static final String CENTOS = "centos";
    public static final String DEBIAN = "debian";
    public static final String WINDOWS = "windows";
    @Deprecated
    public static final String DEFAULT_OPERATING_SYSTEM = "centos";
    private String display;
    private boolean isUnix;

    @Deprecated
    public OperatingSystem() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.display;
            }
            case 2: {
                return this.isUnix;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getName() {
        return this.pkey;
    }

    public String getDisplay() {
        return this.display;
    }

    public boolean isUnix() {
        return this.isUnix;
    }

    public OperatingSystemVersion getOperatingSystemVersion(AoservConnector conn, String version, Architecture architecture) throws IOException, SQLException {
        return conn.getDistribution().getOperatingSystemVersion().getOperatingSystemVersion(this, version, architecture);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.OPERATING_SYSTEMS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.display = result.getString(2);
        this.isUnix = result.getBoolean(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.display = in.readUTF();
        this.isUnix = in.readBoolean();
    }

    @Override
    public String toStringImpl() {
        return this.display;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeUTF(this.display);
        out.writeBoolean(this.isUnix);
    }
}

