/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.distribution.Architecture;
import com.aoindustries.aoserv.client.distribution.OperatingSystem;
import com.aoindustries.aoserv.client.email.List;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class OperatingSystemVersion
extends GlobalObjectIntegerKey<OperatingSystemVersion> {
    static final int COLUMN_PKEY = 0;
    static final String COLUMN_SORT_ORDER_name = "sort_order";
    public static final String VERSION_5 = "5";
    public static final String VERSION_5_DOM0 = "5.dom0";
    public static final String VERSION_7 = "7";
    public static final String VERSION_7_DOM0 = "7.dom0";
    public static final String VERSION_2006_0 = "2006.0";
    public static final String VERSION_ES_4 = "ES 4";
    @Deprecated
    public static final String DEFAULT_OPERATING_SYSTEM_VERSION = "7";
    public static final int CENTOS_5_DOM0_X86_64 = 63;
    public static final int CENTOS_5_DOM0_I686 = 64;
    public static final int CENTOS_5_I686_AND_X86_64 = 67;
    public static final int CENTOS_7_DOM0_X86_64 = 69;
    public static final int CENTOS_7_X86_64 = 70;
    private String operatingSystem;
    private String versionNumber;
    private String versionName;
    private String architecture;
    private String display;
    private boolean isAoservDaemonSupported;
    private short sortOrder;
    private static final PosixPath WWW;
    private static final PosixPath VAR_WWW;
    private static final PosixPath WWWGROUP;
    private static final PosixPath VAR_OPT_APACHE_TOMCAT;
    private static final PosixPath LOGS;
    private static final PosixPath VAR_LOG_HTTPD_SITES;

    @Deprecated
    public OperatingSystemVersion() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.operatingSystem;
            }
            case 2: {
                return this.versionNumber;
            }
            case 3: {
                return this.versionName;
            }
            case 4: {
                return this.architecture;
            }
            case 5: {
                return this.display;
            }
            case 6: {
                return this.isAoservDaemonSupported;
            }
            case 7: {
                return this.sortOrder;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public OperatingSystem getOperatingSystem(AoservConnector conn) throws IOException, SQLException {
        return conn.getDistribution().getOperatingSystem().get(this.operatingSystem);
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getArchitecture_name() {
        return this.architecture;
    }

    public Architecture getArchitecture(AoservConnector connector) throws SQLException, IOException {
        Architecture ar = connector.getDistribution().getArchitecture().get(this.architecture);
        if (ar == null) {
            throw new SQLException("Unable to find Architecture: " + this.architecture);
        }
        return ar;
    }

    public String getDisplay() {
        return this.display;
    }

    public boolean isAoservDaemonSupported() {
        return this.isAoservDaemonSupported;
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.OPERATING_SYSTEM_VERSIONS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.operatingSystem = result.getString(2);
        this.versionNumber = result.getString(3);
        this.versionName = result.getString(4);
        this.architecture = result.getString(5);
        this.display = result.getString(6);
        this.isAoservDaemonSupported = result.getBoolean(7);
        this.sortOrder = result.getShort(8);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.operatingSystem = in.readUTF().intern();
        this.versionNumber = in.readUTF();
        this.versionName = in.readUTF();
        this.architecture = in.readUTF().intern();
        this.display = in.readUTF();
        this.isAoservDaemonSupported = in.readBoolean();
        this.sortOrder = in.readShort();
    }

    @Override
    public String toStringImpl() {
        return this.display;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.operatingSystem);
        out.writeUTF(this.versionNumber);
        out.writeUTF(this.versionName);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_108) >= 0) {
            out.writeUTF(this.architecture);
        }
        out.writeUTF(this.display);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_108) >= 0) {
            out.writeBoolean(this.isAoservDaemonSupported);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_3) >= 0) {
            out.writeShort((int)this.sortOrder);
        }
    }

    public PosixPath getHttpdSitesDirectory() {
        return OperatingSystemVersion.getHttpdSitesDirectory(this.pkey);
    }

    public static PosixPath getHttpdSitesDirectory(int osv) {
        switch (osv) {
            case 67: {
                return WWW;
            }
            case 70: {
                return VAR_WWW;
            }
            case 63: 
            case 64: 
            case 69: {
                return null;
            }
        }
        throw new AssertionError((Object)("Unexpected OperatingSystemVersion: " + osv));
    }

    public PosixPath getHttpdSharedTomcatsDirectory() {
        return OperatingSystemVersion.getHttpdSharedTomcatsDirectory(this.pkey);
    }

    public static PosixPath getHttpdSharedTomcatsDirectory(int osv) {
        switch (osv) {
            case 67: {
                return WWWGROUP;
            }
            case 70: {
                return VAR_OPT_APACHE_TOMCAT;
            }
            case 63: 
            case 64: 
            case 69: {
                return null;
            }
        }
        throw new AssertionError((Object)("Unexpected OperatingSystemVersion: " + osv));
    }

    public PosixPath getHttpdSiteLogsDirectory() {
        return OperatingSystemVersion.getHttpdSiteLogsDirectory(this.pkey);
    }

    public static PosixPath getHttpdSiteLogsDirectory(int osv) {
        switch (osv) {
            case 67: {
                return LOGS;
            }
            case 70: {
                return VAR_LOG_HTTPD_SITES;
            }
            case 63: 
            case 64: 
            case 69: {
                return null;
            }
        }
        throw new AssertionError((Object)("Unexpected OperatingSystemVersion: " + osv));
    }

    public PosixPath getEmailListPath(String name) throws ValidationException {
        return List.getListPath(name, this.pkey);
    }

    public boolean isValidEmailListRegularPath(PosixPath path) {
        return List.isValidRegularPath(path, this.pkey);
    }

    static {
        try {
            WWW = PosixPath.valueOf("/www").intern();
            VAR_WWW = PosixPath.valueOf("/var/www").intern();
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        try {
            WWWGROUP = PosixPath.valueOf("/wwwgroup").intern();
            VAR_OPT_APACHE_TOMCAT = PosixPath.valueOf("/var/opt/apache-tomcat").intern();
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        try {
            LOGS = PosixPath.valueOf("/logs").intern();
            VAR_LOG_HTTPD_SITES = PosixPath.valueOf("/var/log/httpd-sites").intern();
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
    }
}

