/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableIntegerKey;
import com.aoindustries.aoserv.client.distribution.Architecture;
import com.aoindustries.aoserv.client.distribution.OperatingSystem;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;

public final class OperatingSystemVersionTable
extends GlobalTableIntegerKey<OperatingSystemVersion> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("sort_order", true)};

    OperatingSystemVersionTable(AoservConnector connector) {
        super(connector, OperatingSystemVersion.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    OperatingSystemVersion getOperatingSystemVersion(OperatingSystem os, String version, Architecture architecture) throws IOException, SQLException {
        String name = os.getName();
        String arch = architecture.getName();
        for (OperatingSystemVersion osv : this.getRows()) {
            if (!osv.getVersionName().equals(name) || !osv.getVersionNumber().equals(version) || !osv.getArchitecture_name().equals(arch)) continue;
            return osv;
        }
        return null;
    }

    @Override
    public OperatingSystemVersion get(int pkey) throws IOException, SQLException {
        return (OperatingSystemVersion)this.getUniqueRow(0, pkey);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.OPERATING_SYSTEM_VERSIONS;
    }
}

