/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.distribution.SoftwareCategorization;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class Software
extends GlobalObjectStringKey<Software> {
    static final int COLUMN_NAME = 0;
    static final String COLUMN_NAME_name = "name";
    public static final String MYSQL = "MySQL";
    public static final String PHP = "php";
    private String imageFilename;
    private int imageWidth;
    private int imageHeight;
    private String imageAlt;
    private String homePageUrl;

    @Deprecated
    public Software() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.imageFilename;
        }
        if (i == 2) {
            return this.imageWidth == -1 ? null : Integer.valueOf(this.imageWidth);
        }
        if (i == 3) {
            return this.imageHeight == -1 ? null : Integer.valueOf(this.imageHeight);
        }
        if (i == 4) {
            return this.imageAlt;
        }
        if (i == 5) {
            return this.homePageUrl;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public String getImageAlt() {
        return this.imageAlt;
    }

    public String getImageFilename() {
        return this.imageFilename;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public String getName() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TECHNOLOGY_NAMES;
    }

    public List<SoftwareCategorization> getTechnologies(AoservConnector connector) throws IOException, SQLException {
        return connector.getDistribution().getSoftwareCategorization().getTechnologies(this);
    }

    public SoftwareVersion getTechnologyVersion(AoservConnector connector, String version, OperatingSystemVersion osv) throws IOException, SQLException {
        return connector.getDistribution().getSoftwareVersion().getTechnologyVersion(this, version, osv);
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.imageFilename = result.getString(2);
        this.imageWidth = result.getInt(3);
        if (result.wasNull()) {
            this.imageWidth = -1;
        }
        this.imageHeight = result.getInt(4);
        if (result.wasNull()) {
            this.imageHeight = -1;
        }
        this.imageAlt = result.getString(5);
        this.homePageUrl = result.getString(6);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.imageFilename = in.readNullUTF();
        this.imageWidth = in.readCompressedInt();
        this.imageHeight = in.readCompressedInt();
        this.imageAlt = in.readNullUTF();
        this.homePageUrl = in.readNullUTF();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeNullUTF(this.imageFilename);
        out.writeCompressedInt(this.imageWidth);
        out.writeCompressedInt(this.imageHeight);
        out.writeNullUTF(this.imageAlt);
        out.writeNullUTF(this.homePageUrl);
    }
}

