/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.distribution.Software;
import com.aoindustries.aoserv.client.distribution.SoftwareCategory;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SoftwareCategorization
extends GlobalObjectIntegerKey<SoftwareCategorization> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_NAME = 1;
    static final String COLUMN_NAME_name = "name";
    static final String COLUMN_CLASS_name = "class";
    private String name;
    private String clazz;

    @Deprecated
    public SoftwareCategorization() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.name;
        }
        if (i == 2) {
            return this.clazz;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TECHNOLOGIES;
    }

    public SoftwareCategory getTechnologyClass(AoservConnector connector) throws SQLException, IOException {
        SoftwareCategory technologyClass = connector.getDistribution().getSoftwareCategory().get(this.clazz);
        if (technologyClass == null) {
            throw new SQLException("Unable to find TechnologyClass: " + this.clazz);
        }
        return technologyClass;
    }

    public Software getTechnologyName(AoservConnector connector) throws SQLException, IOException {
        Software technologyName = connector.getDistribution().getSoftware().get(this.name);
        if (technologyName == null) {
            throw new SQLException("Unable to find TechnologyName: " + this.name);
        }
        return technologyName;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.name = result.getString(2);
        this.clazz = result.getString(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.name = in.readUTF().intern();
        this.clazz = in.readUTF().intern();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_4) >= 0) {
            out.writeCompressedInt(this.pkey);
        }
        out.writeUTF(this.name);
        out.writeUTF(this.clazz);
    }
}

