/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.distribution.Software;
import com.aoindustries.aoserv.client.master.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Version;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class SoftwareVersion
extends GlobalObjectIntegerKey<SoftwareVersion> {
    static final int COLUMN_PKEY = 0;
    public static final String COLUMN_VERSION_name = "version";
    static final String COLUMN_NAME_name = "name";
    private String name;
    private String version;
    private UnmodifiableTimestamp updated;
    private User.Name owner;
    private int operatingSystemVersion;
    private UnmodifiableTimestamp disableTime;
    private String disableReason;

    @Deprecated
    public SoftwareVersion() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.version;
            }
            case 3: {
                return this.updated;
            }
            case 4: {
                return this.owner;
            }
            case 5: {
                return this.operatingSystemVersion == -1 ? null : Integer.valueOf(this.operatingSystemVersion);
            }
            case 6: {
                return this.disableTime;
            }
            case 7: {
                return this.disableReason;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Version getHttpdTomcatVersion(AoservConnector connector) throws IOException, SQLException {
        return connector.getWeb_tomcat().getVersion().get(this.pkey);
    }

    public User getOwner(AoservConnector connector) throws SQLException, IOException {
        if (this.owner == null) {
            return null;
        }
        User obj = connector.getMaster().getUser().get(this.owner);
        if (obj == null) {
            throw new SQLException("Unable to find MasterUser: " + this.owner);
        }
        return obj;
    }

    public int getOperatingSystemVersion_id() {
        return this.operatingSystemVersion;
    }

    public OperatingSystemVersion getOperatingSystemVersion(AoservConnector conn) throws SQLException, IOException {
        OperatingSystemVersion osv = conn.getDistribution().getOperatingSystemVersion().get(this.operatingSystemVersion);
        if (osv == null) {
            throw new SQLException("Unable to find OperatingSystemVersion: " + this.operatingSystemVersion);
        }
        return osv;
    }

    public boolean isEnabled(long time) {
        return this.disableTime == null || this.disableTime.getTime() > time;
    }

    public UnmodifiableTimestamp getDisableTime() {
        return this.disableTime;
    }

    public String getDisableReason() {
        return this.disableReason;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TECHNOLOGY_VERSIONS;
    }

    public String getTechnologyName_name() {
        return this.name;
    }

    public Software getTechnologyName(AoservConnector connector) throws SQLException, IOException {
        Software technologyName = connector.getDistribution().getSoftware().get(this.name);
        if (technologyName == null) {
            throw new SQLException("Unable to find TechnologyName: " + this.name);
        }
        return technologyName;
    }

    public UnmodifiableTimestamp getUpdated() {
        return this.updated;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.name = result.getString(2);
            this.version = result.getString(3);
            this.updated = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(4));
            String s = result.getString(5);
            this.owner = "*".equals(s) ? null : User.Name.valueOf(s);
            this.operatingSystemVersion = result.getInt(6);
            if (result.wasNull()) {
                this.operatingSystemVersion = -1;
            }
            this.disableTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(7));
            this.disableReason = result.getString(8);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.name = in.readUTF().intern();
            this.version = in.readUTF();
            this.updated = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            String s = in.readUTF();
            this.owner = "*".equals(s) ? null : User.Name.valueOf(s).intern();
            this.operatingSystemVersion = in.readCompressedInt();
            this.disableTime = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            this.disableReason = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name);
        out.writeUTF(this.version);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.updated.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.updated, (DataOutputStream)out);
        }
        out.writeUTF(this.owner == null ? "*" : this.owner.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_108) >= 0) {
            out.writeCompressedInt(this.operatingSystemVersion);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_78) >= 0) {
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
                out.writeLong(this.disableTime == null ? -1L : this.disableTime.getTime());
            } else {
                SQLStreamables.writeNullTimestamp((Timestamp)this.disableTime, (DataOutputStream)out);
            }
            out.writeNullUTF(this.disableReason);
        }
    }
}

