/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution;

import com.aoapps.lang.Strings;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableIntegerKey;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.distribution.Software;
import com.aoindustries.aoserv.client.distribution.SoftwareCategorization;
import com.aoindustries.aoserv.client.distribution.SoftwareCategory;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public final class SoftwareVersionTable
extends GlobalTableIntegerKey<SoftwareVersion> {
    public static final int NONE = 0;
    public static final int NAME = 1;
    public static final int VERSION = 2;
    public static final int UPDATED = 3;
    static final String[] orderLabels = new String[]{"None", "Name", "Version", "Updated"};
    public static final int NUM_ORDER_LABELS = 4;
    private static UnmodifiableTimestamp maximumUpdatedTime = null;
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true), new AoservTable.OrderBy("version", true)};

    SoftwareVersionTable(AoservConnector connector) {
        super(connector, SoftwareVersion.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Class<SoftwareVersionTable> clazz = SoftwareVersionTable.class;
        synchronized (SoftwareVersionTable.class) {
            maximumUpdatedTime = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public SoftwareVersion get(int pkey) throws IOException, SQLException {
        return (SoftwareVersion)this.getUniqueRow(0, pkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnmodifiableTimestamp getMaximumUpdatedTime() throws IOException, SQLException {
        Class<SoftwareVersionTable> clazz = SoftwareVersionTable.class;
        synchronized (SoftwareVersionTable.class) {
            if (maximumUpdatedTime == null) {
                List versions = this.getRows();
                int size = versions.size();
                UnmodifiableTimestamp max = null;
                for (int c = 0; c < size; ++c) {
                    SoftwareVersion version = (SoftwareVersion)versions.get(c);
                    UnmodifiableTimestamp mod = version.getUpdated();
                    if (max != null && mod.compareTo((Timestamp)max) <= 0) continue;
                    max = mod;
                }
                maximumUpdatedTime = max;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return maximumUpdatedTime;
        }
    }

    public static String getOrderLabel(int index) {
        return orderLabels[index];
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TECHNOLOGY_VERSIONS;
    }

    SoftwareVersion getTechnologyVersion(Software techName, String version, OperatingSystemVersion osv) throws IOException, SQLException {
        String name = techName.getName();
        int osvPkey = osv.getPkey();
        List table = this.getRows();
        int size = table.size();
        for (int c = 0; c < size; ++c) {
            SoftwareVersion tv = (SoftwareVersion)table.get(c);
            if (!tv.getTechnologyName_name().equals(name) || !tv.getVersion().equals(version) || tv.getOperatingSystemVersion_id() != osvPkey) continue;
            return tv;
        }
        return null;
    }

    public List<SoftwareVersion> getTechnologyVersions(OperatingSystemVersion osv, String name, List<SoftwareCategory> classes, String version, int orderBy) throws IOException, SQLException {
        String[] nameWords = null;
        if (name != null) {
            nameWords = Strings.split((String)name);
            int len = nameWords.length;
            for (int c = 0; c < len; ++c) {
                nameWords[c] = nameWords[c].toLowerCase();
            }
        }
        String[] versionWords = null;
        if (version != null) {
            versionWords = Strings.split((String)version);
            int len = versionWords.length;
            for (int c = 0; c < len; ++c) {
                versionWords[c] = versionWords[c].toLowerCase();
            }
        }
        List table = this.getRows();
        ArrayList<SoftwareVersion> matches = new ArrayList<SoftwareVersion>();
        int tableSize = table.size();
        for (int c = 0; c < tableSize; ++c) {
            String s;
            SoftwareVersion tv = (SoftwareVersion)table.get(c);
            if (osv != null && !osv.equals(tv.getOperatingSystemVersion(this.connector))) continue;
            boolean found = true;
            if (nameWords != null) {
                s = tv.getTechnologyName_name().toLowerCase();
                for (String nameWord : nameWords) {
                    if (s.contains(nameWord)) continue;
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            if (versionWords != null) {
                s = tv.getVersion().toLowerCase();
                for (String versionWord : versionWords) {
                    if (s.contains(versionWord)) continue;
                    found = false;
                    break;
                }
            }
            if (!found) continue;
            if (!classes.isEmpty()) {
                List<SoftwareCategorization> rowClasses = tv.getTechnologyName(this.connector).getTechnologies(this.connector);
                found = false;
                block5: for (SoftwareCategory matchClass : classes) {
                    for (SoftwareCategorization rowClass : rowClasses) {
                        if (!rowClass.getTechnologyClass(this.connector).equals(matchClass)) continue;
                        found = true;
                        break block5;
                    }
                }
            }
            if (!found) continue;
            int len = matches.size();
            int addAt = -1;
            for (int d = 0; d < len && addAt == -1; ++d) {
                SoftwareVersion compVersion = (SoftwareVersion)matches.get(d);
                if (orderBy == 1) {
                    if (tv.getTechnologyName_name().compareToIgnoreCase(compVersion.getTechnologyName_name()) >= 0) continue;
                    addAt = d;
                    continue;
                }
                if (orderBy == 2) {
                    if (tv.getVersion().compareToIgnoreCase(compVersion.getVersion()) >= 0) continue;
                    addAt = d;
                    continue;
                }
                if (orderBy == 3) {
                    if (tv.getUpdated().compareTo((Timestamp)compVersion.getUpdated()) <= 0) continue;
                    addAt = d;
                    continue;
                }
                throw new IllegalArgumentException("Invalid value for orderBy: " + orderBy);
            }
            matches.add(addAt == -1 ? len : addAt, tv);
        }
        return matches;
    }
}

