/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution.management;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.FilesystemCachedObject;
import com.aoindustries.aoserv.client.distribution.OperatingSystemVersion;
import com.aoindustries.aoserv.client.distribution.management.DistroFileType;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class DistroFile
extends FilesystemCachedObject<Integer, DistroFile> {
    static final int COLUMN_PKEY = 0;
    public static final int COLUMN_OPERATING_SYSTEM_VERSION = 1;
    public static final int COLUMN_PATH = 2;
    static final String COLUMN_PATH_name = "path";
    static final String COLUMN_OPERATING_SYSTEM_VERSION_name = "operating_system_version";
    static final int MAX_PATH_LENGTH = 194;
    static final int MAX_TYPE_LENGTH = 10;
    static final int MAX_SYMLINK_TARGET_LENGTH = 96;
    static final int MAX_LINUX_ACCOUNT_LENGTH = 15;
    static final int MAX_LINUX_GROUP_LENGTH = 15;
    public static final long NULL_SIZE = -1L;
    private int pkey;
    private int operatingSystemVersion;
    private PosixPath path;
    private boolean optional;
    private String type;
    private long mode;
    private User.Name linuxAccount;
    private Group.Name linuxGroup;
    private long size;
    private boolean hasFileSha;
    private long fileSha0;
    private long fileSha1;
    private long fileSha2;
    private long fileSha3;
    private String symlinkTarget;

    @Deprecated
    public DistroFile() {
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DistroFile && ((DistroFile)obj).pkey == this.pkey;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.operatingSystemVersion;
            }
            case 2: {
                return this.path;
            }
            case 3: {
                return this.optional;
            }
            case 4: {
                return this.type;
            }
            case 5: {
                return this.mode;
            }
            case 6: {
                return this.linuxAccount;
            }
            case 7: {
                return this.linuxGroup;
            }
            case 8: {
                return this.size == -1L ? null : Long.valueOf(this.size);
            }
            case 9: {
                return this.hasFileSha ? Long.valueOf(this.fileSha0) : null;
            }
            case 10: {
                return this.hasFileSha ? Long.valueOf(this.fileSha1) : null;
            }
            case 11: {
                return this.hasFileSha ? Long.valueOf(this.fileSha2) : null;
            }
            case 12: {
                return this.hasFileSha ? Long.valueOf(this.fileSha3) : null;
            }
            case 13: {
                return this.symlinkTarget;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getPkey() {
        return this.pkey;
    }

    public OperatingSystemVersion getOperatingSystemVersion() throws SQLException, IOException {
        OperatingSystemVersion osv = this.table.getConnector().getDistribution().getOperatingSystemVersion().get(this.operatingSystemVersion);
        if (osv == null) {
            throw new SQLException("Unable to find OperatingSystemVersion: " + this.operatingSystemVersion);
        }
        return osv;
    }

    public PosixPath getPath() {
        return this.path;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public DistroFileType getType() throws SQLException, IOException {
        DistroFileType fileType = this.table.getConnector().getDistribution_management().getDistroFileType().get(this.type);
        if (fileType == null) {
            throw new SQLException("Unable to find DistroFileType: " + this.type);
        }
        return fileType;
    }

    public long getMode() {
        return this.mode;
    }

    public User getLinuxAccount() throws SQLException, IOException {
        if (this.table == null) {
            throw new NullPointerException("table is null");
        }
        if (this.table.getConnector() == null) {
            throw new NullPointerException("table.getConnector() is null");
        }
        User linuxAccount = this.table.getConnector().getLinux().getUser().get(this.linuxAccount);
        if (linuxAccount == null) {
            throw new SQLException("Unable to find LinuxAccount: " + this.linuxAccount);
        }
        return linuxAccount;
    }

    public Group getLinuxGroup() throws SQLException, IOException {
        Group linuxGroup = this.table.getConnector().getLinux().getGroup().get(this.linuxGroup);
        if (linuxGroup == null) {
            throw new SQLException("Unable to find LinuxGroup: " + this.linuxGroup);
        }
        return linuxGroup;
    }

    public long getSize() {
        return this.size;
    }

    public boolean hasFileSha256() {
        return this.hasFileSha;
    }

    public long getFileSha256_0() {
        return this.fileSha0;
    }

    public long getFileSha256_1() {
        return this.fileSha1;
    }

    public long getFileSha256_2() {
        return this.fileSha2;
    }

    public long getFileSha256_3() {
        return this.fileSha3;
    }

    public String getSymlinkTarget() {
        return this.symlinkTarget;
    }

    @Override
    public Integer getKey() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DISTRO_FILES;
    }

    @Override
    public int hashCode() {
        return this.pkey;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.operatingSystemVersion = result.getInt(pos++);
            this.path = PosixPath.valueOf(result.getString(pos++));
            this.optional = result.getBoolean(pos++);
            this.type = result.getString(pos++);
            this.mode = result.getLong(pos++);
            this.linuxAccount = User.Name.valueOf(result.getString(pos++));
            this.linuxGroup = Group.Name.valueOf(result.getString(pos++));
            this.size = result.getLong(pos++);
            if (result.wasNull()) {
                this.size = -1L;
            }
            this.fileSha0 = result.getLong(pos++);
            this.fileSha1 = result.getLong(pos++);
            this.fileSha2 = result.getLong(pos++);
            this.fileSha3 = result.getLong(pos++);
            this.hasFileSha = !result.wasNull();
            this.symlinkTarget = result.getString(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.operatingSystemVersion = in.readCompressedInt();
            this.path = PosixPath.valueOf(in.readCompressedUTF());
            this.optional = in.readBoolean();
            this.type = in.readCompressedUTF().intern();
            this.mode = in.readLong();
            this.linuxAccount = User.Name.valueOf(in.readCompressedUTF()).intern();
            this.linuxGroup = Group.Name.valueOf(in.readCompressedUTF()).intern();
            this.size = in.readLong();
            this.hasFileSha = in.readBoolean();
            if (this.hasFileSha) {
                this.fileSha0 = in.readLong();
                this.fileSha1 = in.readLong();
                this.fileSha2 = in.readLong();
                this.fileSha3 = in.readLong();
            } else {
                this.fileSha0 = 0L;
                this.fileSha1 = 0L;
                this.fileSha2 = 0L;
                this.fileSha3 = 0L;
            }
            this.symlinkTarget = in.readBoolean() ? in.readCompressedUTF() : null;
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    private static void writeChars(String s, DataOutputStream out) throws IOException {
        out.writeInt(s.length());
        out.writeChars(s);
    }

    private static String readChars(DataInputStream in) throws IOException {
        int len = in.readInt();
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = in.readChar();
        }
        return new String(chars);
    }

    @Override
    public void readRecord(DataInputStream in) throws IOException {
        try {
            this.pkey = in.readInt();
            this.operatingSystemVersion = in.readInt();
            this.path = PosixPath.valueOf(DistroFile.readChars(in));
            this.optional = in.readBoolean();
            this.type = DistroFile.readChars(in).intern();
            this.mode = in.readLong();
            this.linuxAccount = User.Name.valueOf(DistroFile.readChars(in)).intern();
            this.linuxGroup = Group.Name.valueOf(DistroFile.readChars(in)).intern();
            this.size = in.readLong();
            this.hasFileSha = in.readBoolean();
            if (this.hasFileSha) {
                this.fileSha0 = in.readLong();
                this.fileSha1 = in.readLong();
                this.fileSha2 = in.readLong();
                this.fileSha3 = in.readLong();
            } else {
                this.fileSha0 = 0L;
                this.fileSha1 = 0L;
                this.fileSha2 = 0L;
                this.fileSha3 = 0L;
            }
            this.symlinkTarget = in.readBoolean() ? DistroFile.readChars(in) : null;
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_108) >= 0) {
            out.writeCompressedInt(this.pkey);
            out.writeCompressedInt(this.operatingSystemVersion);
        }
        out.writeCompressedUTF(this.path.toString(), 0);
        out.writeBoolean(this.optional);
        out.writeCompressedUTF(this.type, 1);
        out.writeLong(this.mode);
        out.writeCompressedUTF(this.linuxAccount.toString(), 2);
        out.writeCompressedUTF(this.linuxGroup.toString(), 3);
        out.writeLong(this.size);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80) >= 0) {
            out.writeBoolean(this.hasFileSha);
            if (this.hasFileSha) {
                out.writeLong(this.fileSha0);
                out.writeLong(this.fileSha1);
                out.writeLong(this.fileSha2);
                out.writeLong(this.fileSha3);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.symlinkTarget != null);
        if (this.symlinkTarget != null) {
            out.writeCompressedUTF(this.symlinkTarget, 4);
        }
    }

    @Override
    public void writeRecord(DataOutputStream out) throws IOException {
        out.writeInt(this.pkey);
        out.writeInt(this.operatingSystemVersion);
        String pathStr = this.path.toString();
        if (pathStr.length() > 194) {
            throw new IOException("path.length()>194: " + pathStr.length());
        }
        DistroFile.writeChars(pathStr, out);
        out.writeBoolean(this.optional);
        if (this.type.length() > 10) {
            throw new IOException("type.length()>10: " + this.type.length());
        }
        DistroFile.writeChars(this.type, out);
        out.writeLong(this.mode);
        String linuxAccountStr = this.linuxAccount.toString();
        if (linuxAccountStr.length() > 15) {
            throw new IOException("linux_account.length()>15: " + linuxAccountStr.length());
        }
        DistroFile.writeChars(linuxAccountStr, out);
        String linuxGroupStr = this.linuxGroup.toString();
        if (linuxGroupStr.length() > 15) {
            throw new IOException("linux_group.length()>15: " + linuxGroupStr.length());
        }
        DistroFile.writeChars(linuxGroupStr, out);
        out.writeLong(this.size);
        out.writeBoolean(this.hasFileSha);
        if (this.hasFileSha) {
            out.writeLong(this.fileSha0);
            out.writeLong(this.fileSha1);
            out.writeLong(this.fileSha2);
            out.writeLong(this.fileSha3);
        }
        out.writeBoolean(this.symlinkTarget != null);
        if (this.symlinkTarget != null) {
            if (this.symlinkTarget.length() > 96) {
                throw new IOException("symlink_target.length()>96: " + this.symlinkTarget.length());
            }
            DistroFile.writeChars(this.symlinkTarget, out);
        }
    }
}

