/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.distribution.management;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.FilesystemCachedTable;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.distribution.management.DistroFile;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;

public final class DistroFileTable
extends FilesystemCachedTable<Integer, DistroFile> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("path", true), new AoservTable.OrderBy("operating_system_version", true)};

    DistroFileTable(AoservConnector connector) {
        super(connector, DistroFile.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    @Deprecated
    public DistroFile get(Object pkey) throws IOException, SQLException {
        return (DistroFile)this.getUniqueRow(0, pkey);
    }

    public DistroFile get(int pkey) throws IOException, SQLException {
        return (DistroFile)this.getUniqueRow(0, pkey);
    }

    @Override
    public int getRecordLength() {
        return 739;
    }

    @Override
    public int getCachedRowCount() throws IOException, SQLException {
        if (this.isLoaded()) {
            return super.getCachedRowCount();
        }
        return this.connector.requestIntQuery(true, AoservProtocol.CommandId.GET_CACHED_ROW_COUNT, new Object[]{Table.TableId.DISTRO_FILES});
    }

    @Override
    public int size() throws IOException, SQLException {
        if (this.isLoaded()) {
            return super.size();
        }
        return this.connector.requestIntQuery(true, AoservProtocol.CommandId.GET_ROW_COUNT, new Object[]{Table.TableId.DISTRO_FILES});
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DISTRO_FILES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("start_distro")) {
            if (Aosh.checkParamCount("start_distro", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().startDistro(args[1], Aosh.parseBoolean(args[2], "include_user"));
            }
            return true;
        }
        return false;
    }

    public void startDistro(Server server, boolean includeUser) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.START_DISTRO, server.getPkey(), includeUser);
    }
}

