/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.dns;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.dns.RecordType;
import com.aoindustries.aoserv.client.dns.Zone;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class Record
extends CachedObjectIntegerKey<Record>
implements Removable {
    static final int COLUMN_ID = 0;
    static final int COLUMN_ZONE = 1;
    static final String COLUMN_ZONE_name = "zone";
    static final String COLUMN_DOMAIN_name = "domain";
    static final String COLUMN_TYPE_name = "type";
    static final String COLUMN_PRIORITY_name = "priority";
    static final String COLUMN_WEIGHT_name = "weight";
    static final String COLUMN_TAG_name = "tag";
    static final String COLUMN_DESTINATION_name = "destination";
    public static final int NO_PRIORITY = -1;
    public static final int NO_WEIGHT = -1;
    public static final int NO_PORT = -1;
    public static final short NO_FLAG = -1;
    public static final int NO_TTL = -1;
    public static final String CAA_TAG_ISSUE = "issue";
    public static final String CAA_TAG_ISSUEWILD = "issuewild";
    public static final String CAA_TAG_IODEF = "iodef";
    public static final String CAA_TAG_CONTACTEMAIL = "contactemail";
    public static final String CAA_TAG_CONTACTPHONE = "contactphone";
    private String zone;
    private String domain;
    private String type;
    private int priority;
    private int weight;
    private int port;
    private short flag;
    private String tag;
    private String destination;
    private int dhcpAddress;
    private int ttl;

    @Deprecated
    public Record() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.zone;
            }
            case 2: {
                return this.domain;
            }
            case 3: {
                return this.type;
            }
            case 4: {
                return this.priority == -1 ? null : Integer.valueOf(this.priority);
            }
            case 5: {
                return this.weight == -1 ? null : Integer.valueOf(this.weight);
            }
            case 6: {
                return this.port == -1 ? null : Integer.valueOf(this.port);
            }
            case 7: {
                return this.flag == -1 ? null : Short.valueOf(this.flag);
            }
            case 8: {
                return this.tag;
            }
            case 9: {
                return this.destination;
            }
            case 10: {
                return this.dhcpAddress == -1 ? null : Integer.valueOf(this.dhcpAddress);
            }
            case 11: {
                return this.ttl == -1 ? null : Integer.valueOf(this.ttl);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public String getZone_zone() {
        return this.zone;
    }

    public Zone getZone() throws SQLException, IOException {
        Zone obj = this.table.getConnector().getDns().getZone().get(this.zone);
        if (obj == null) {
            throw new SQLException("Unable to find DNSZone: " + this.zone);
        }
        return obj;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getType_type() {
        return this.type;
    }

    public RecordType getType() throws SQLException, IOException {
        RecordType obj = this.table.getConnector().getDns().getRecordType().get(this.type);
        if (obj == null) {
            throw new SQLException("Unable to find DNSType: " + this.type);
        }
        return obj;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public static boolean isValidFlag(short flag) {
        return flag == -1 || flag >= 0 && flag <= 255;
    }

    public short getFlag() {
        assert (Record.isValidFlag(this.flag));
        return this.flag;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDestination() {
        return this.destination;
    }

    public Integer getDhcpAddress_id() {
        return this.dhcpAddress == -1 ? null : Integer.valueOf(this.dhcpAddress);
    }

    public IpAddress getDhcpAddress() throws SQLException, IOException {
        if (this.dhcpAddress == -1) {
            return null;
        }
        IpAddress ia = this.table.getConnector().getNet().getIpAddress().get(this.dhcpAddress);
        if (ia == null) {
            throw new SQLException("Unable to find IpAddress: " + this.dhcpAddress);
        }
        return ia;
    }

    public int getTtl() {
        return this.ttl;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt("id");
        this.zone = result.getString(COLUMN_ZONE_name);
        this.domain = result.getString(COLUMN_DOMAIN_name);
        this.type = result.getString(COLUMN_TYPE_name);
        this.priority = result.getInt(COLUMN_PRIORITY_name);
        if (result.wasNull()) {
            this.priority = -1;
        }
        this.weight = result.getInt(COLUMN_WEIGHT_name);
        if (result.wasNull()) {
            this.weight = -1;
        }
        this.port = result.getInt("port");
        if (result.wasNull()) {
            this.port = -1;
        }
        this.flag = result.getShort("flag");
        if (result.wasNull()) {
            this.flag = (short)-1;
        }
        if (!Record.isValidFlag(this.flag)) {
            throw new SQLException("Invalid flag: " + this.flag);
        }
        this.tag = result.getString(COLUMN_TAG_name);
        this.destination = result.getString(COLUMN_DESTINATION_name);
        this.dhcpAddress = result.getInt("dhcpAddress");
        if (result.wasNull()) {
            this.dhcpAddress = -1;
        }
        this.ttl = result.getInt("ttl");
        if (result.wasNull()) {
            this.ttl = -1;
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.zone = in.readUTF().intern();
        this.domain = in.readUTF().intern();
        this.type = in.readUTF().intern();
        this.priority = in.readCompressedInt();
        this.weight = in.readCompressedInt();
        this.port = in.readCompressedInt();
        this.flag = in.readShort();
        if (!Record.isValidFlag(this.flag)) {
            throw new IOException("Invalid flag: " + this.flag);
        }
        this.tag = InternUtils.intern((String)in.readNullUTF());
        this.destination = in.readUTF().intern();
        this.dhcpAddress = in.readCompressedInt();
        this.ttl = in.readCompressedInt();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.zone);
        out.writeUTF(this.domain);
        out.writeUTF(this.type);
        out.writeCompressedInt(this.priority);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_72) >= 0) {
            out.writeCompressedInt(this.weight);
            out.writeCompressedInt(this.port);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_86_0) >= 0) {
            assert (Record.isValidFlag(this.flag));
            out.writeShort((int)this.flag);
            out.writeNullUTF(this.tag);
        }
        out.writeUTF(this.destination);
        out.writeCompressedInt(this.dhcpAddress);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_127) >= 0) {
            out.writeCompressedInt(this.ttl);
        }
    }

    public String getAbsoluteDomain() {
        if ("@".equals(this.domain)) {
            return this.zone;
        }
        if (this.domain.endsWith(".")) {
            return this.domain;
        }
        return this.domain + '.' + this.zone;
    }

    static String cleanTxt(String destination) {
        int len = destination.length();
        StringBuilder txt = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = destination.charAt(i);
            if (ch == '\"' || ch < ' ' || ch >= '\u007f') continue;
            txt.append(ch);
        }
        String cleaned = txt.length() == len ? destination : txt.toString();
        return cleaned.trim();
    }

    private static boolean isSpf1(String destination) {
        String txt = Record.cleanTxt(destination);
        return "v=spf1".equals(txt) || txt.startsWith("v=spf1 ");
    }

    public boolean hasConflict(Record other) {
        String domain2;
        String domain1 = this.getAbsoluteDomain();
        if (domain1.equals(domain2 = other.getAbsoluteDomain())) {
            if (this.type.equals("CNAME") || other.type.equals("CNAME")) {
                return true;
            }
            if (this.type.equals("TXT") && other.type.equals("TXT") && Record.isSpf1(this.destination) && Record.isSpf1(other.destination)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DNS_RECORDS;
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.DNS_RECORDS, this.pkey});
    }

    @Override
    public String toStringImpl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.zone).append(": ").append(this.domain);
        if (this.ttl != -1) {
            sb.append(' ').append(this.ttl);
        }
        sb.append(" IN ").append(this.type);
        if (this.priority != -1) {
            sb.append(' ').append(this.priority);
        }
        if (this.weight != -1) {
            sb.append(' ').append(this.weight);
        }
        if (this.port != -1) {
            sb.append(' ').append(this.port);
        }
        if (this.flag != -1) {
            sb.append(' ').append(this.flag);
        }
        if (this.tag != null) {
            sb.append(' ').append(this.tag);
        }
        sb.append(' ').append(this.destination);
        return sb.toString();
    }
}

