/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.dns;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.dns.Record;
import com.aoindustries.aoserv.client.dns.RecordType;
import com.aoindustries.aoserv.client.dns.Zone;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class RecordTable
extends CachedTableIntegerKey<Record> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("zone", true), new AoservTable.OrderBy("domain", true), new AoservTable.OrderBy("type", true), new AoservTable.OrderBy("priority", true), new AoservTable.OrderBy("weight", true), new AoservTable.OrderBy("tag", true), new AoservTable.OrderBy("destination", true)};

    RecordTable(AoservConnector connector) {
        super(connector, Record.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addDnsRecord(Zone zone, String domain, RecordType type, int priority, int weight, int port, short flag, String tag, String destination, int ttl) throws IOException, SQLException {
        if (!Record.isValidFlag(flag)) {
            throw new IllegalArgumentException("Invalid flag: " + flag);
        }
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.DNS_RECORDS, zone.getZone(), domain, type.getType(), priority, weight, port, flag, tag == null ? "" : tag, destination, ttl});
    }

    @Override
    public Record get(int id) throws IOException, SQLException {
        return (Record)this.getUniqueRow(0, id);
    }

    List<Record> getRecords(Zone dnsZone) throws IOException, SQLException {
        return this.getIndexedRows(1, dnsZone.getZone());
    }

    List<Record> getRecords(Zone dnsZone, String domain, RecordType dnsType) throws IOException, SQLException {
        String type = dnsType.getType();
        List<Record> cached = this.getRecords(dnsZone);
        int size = cached.size();
        ArrayList<Record> matches = new ArrayList<Record>(size);
        for (int c = 0; c < size; ++c) {
            Record rec = cached.get(c);
            if (!rec.getType_type().equals(type) || !rec.getDomain().equals(domain)) continue;
            matches.add(rec);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DNS_RECORDS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_dns_record")) {
            if (Aosh.checkMinParamCount("add_dns_record", args, 3, (PrintWriter)err)) {
                int ttl;
                String destination;
                String tag;
                int flag;
                int port;
                int weight;
                int priority;
                String zone = args[1];
                String domain = args[2];
                String type = args[3];
                if (("A".equals(type) || "AAAA".equals(type) || "CNAME".equals(type) || "NS".equals(type) || "PTR".equals(type) || "TXT".equals(type)) && (args.length == 5 || args.length == 6)) {
                    priority = -1;
                    weight = -1;
                    port = -1;
                    flag = -1;
                    tag = null;
                    destination = args[4];
                    ttl = args.length <= 5 || args[5].isEmpty() ? -1 : Aosh.parseInt(args[5], "ttl");
                } else if ("CAA".equals(type) && (args.length == 7 || args.length == 8)) {
                    priority = -1;
                    weight = -1;
                    port = -1;
                    flag = Aosh.parseShort(args[4], "flag");
                    tag = args[5];
                    destination = args[6];
                    ttl = args.length <= 7 || args[7].isEmpty() ? -1 : Aosh.parseInt(args[7], "ttl");
                } else if ("MX".equals(type) && (args.length == 6 || args.length == 7)) {
                    priority = Aosh.parseInt(args[4], "priority");
                    weight = -1;
                    port = -1;
                    flag = -1;
                    tag = null;
                    destination = args[5];
                    ttl = args.length <= 6 || args[6].isEmpty() ? -1 : Aosh.parseInt(args[6], "ttl");
                } else if ("SRV".equals(type) && (args.length == 8 || args.length == 9)) {
                    priority = Aosh.parseInt(args[4], "priority");
                    weight = Aosh.parseInt(args[5], "weight");
                    port = Aosh.parseInt(args[6], "port");
                    flag = -1;
                    tag = null;
                    destination = args[7];
                    ttl = args.length <= 8 || args[8].isEmpty() ? -1 : Aosh.parseInt(args[8], "ttl");
                } else if (args.length == 10 || Aosh.checkParamCount("add_dns_record", args, 10, (PrintWriter)err)) {
                    priority = args[4].isEmpty() ? -1 : Aosh.parseInt(args[4], "priority");
                    weight = args[5].isEmpty() ? -1 : Aosh.parseInt(args[5], "weight");
                    port = args[6].isEmpty() ? -1 : Aosh.parseInt(args[6], "port");
                    flag = args[7].isEmpty() ? -1 : (int)Aosh.parseShort(args[7], "flag");
                    tag = args[8].isEmpty() ? null : args[8];
                    destination = args[9];
                    ttl = args.length <= 10 || args[10].isEmpty() ? -1 : Aosh.parseInt(args[10], "ttl");
                } else {
                    return true;
                }
                out.println(this.connector.getSimpleClient().addDnsRecord(zone, domain, type, priority, weight, port, (short)flag, tag, destination, ttl));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_dns_record")) {
            if (args.length == 2) {
                this.connector.getSimpleClient().removeDnsRecord(Aosh.parseInt(args[1], "pkey"));
                return true;
            }
            if (args.length == 6) {
                this.connector.getSimpleClient().removeDnsRecord(args[1], args[2], args[3], args[4].isEmpty() ? null : args[4], args[5]);
                return true;
            }
            err.print("aosh: ");
            err.print("remove_dns_record");
            err.println(": must be either 1 or 5 parameters");
            err.flush();
            return false;
        }
        return false;
    }
}

