/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.dns;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.AddressFamily;
import com.aoapps.net.DomainName;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.dns.ZoneTable;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class RecordType
extends GlobalObjectStringKey<RecordType> {
    static final int COLUMN_TYPE = 0;
    static final String COLUMN_DESCRIPTION_name = "description";
    public static final String A = "A";
    public static final String AAAA = "AAAA";
    public static final String CNAME = "CNAME";
    public static final String CAA = "CAA";
    public static final String MX = "MX";
    public static final String NS = "NS";
    public static final String PTR = "PTR";
    public static final String SRV = "SRV";
    public static final String TXT = "TXT";
    private String description;
    private boolean hasPriority;
    private boolean hasWeight;
    private boolean hasPort;
    private boolean hasFlag;
    private boolean hasTag;
    private boolean paramIp;

    @Deprecated
    public RecordType() {
    }

    public void checkDestination(String tag, String destination) throws IllegalArgumentException {
        RecordType.checkDestination(this.pkey, tag, destination);
    }

    public static void checkDestination(String type, String tag, String destination) throws IllegalArgumentException {
        block17: {
            String origDest = destination;
            if (destination.isEmpty()) {
                throw new IllegalArgumentException("Destination may not by empty");
            }
            if (type.equals(A)) {
                try {
                    InetAddress parsed = InetAddress.valueOf((String)destination);
                    if (parsed.getAddressFamily() != AddressFamily.INET) {
                        throw new IllegalArgumentException("A type requires IPv4 address: " + destination);
                    }
                    break block17;
                }
                catch (ValidationException e) {
                    throw new IllegalArgumentException(e.getLocalizedMessage(), e);
                }
            }
            if (type.equals(AAAA)) {
                try {
                    InetAddress parsed = InetAddress.valueOf((String)destination);
                    if (parsed.getAddressFamily() != AddressFamily.INET6) {
                        throw new IllegalArgumentException("AAAA type requires IPv6 address: " + destination);
                    }
                    break block17;
                }
                catch (ValidationException e) {
                    throw new IllegalArgumentException(e.getLocalizedMessage(), e);
                }
            }
            if (type.equals(CAA)) {
                if (tag == null) {
                    throw new IllegalArgumentException("tag required for type = CAA");
                }
                if ("issue".equals(tag) || "issuewild".equals(tag)) {
                    ValidationResult result;
                    String issuerDomainName;
                    int semicolon = destination.indexOf(59);
                    String string = issuerDomainName = semicolon == -1 ? destination : destination.substring(0, semicolon);
                    if (!issuerDomainName.isEmpty() && !(result = DomainName.validate((String)issuerDomainName)).isValid()) {
                        throw new IllegalArgumentException("Invalid issuer domain: " + result.toString());
                    }
                }
            } else if (!type.equals(TXT)) {
                if (destination.charAt(destination.length() - 1) == '.') {
                    destination = destination.substring(0, destination.length() - 1);
                }
                if (!ZoneTable.isValidHostnamePart(destination) && !DomainName.validate((String)destination).isValid()) {
                    throw new IllegalArgumentException("Invalid destination hostname: " + origDest);
                }
            }
        }
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.description;
            }
            case 2: {
                return this.hasPriority;
            }
            case 3: {
                return this.hasWeight;
            }
            case 4: {
                return this.hasPort;
            }
            case 5: {
                return this.hasFlag;
            }
            case 6: {
                return this.hasTag;
            }
            case 7: {
                return this.paramIp;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DNS_TYPES;
    }

    public String getType() {
        return this.pkey;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString("type");
        this.description = result.getString(COLUMN_DESCRIPTION_name);
        this.hasPriority = result.getBoolean("has_priority");
        this.hasWeight = result.getBoolean("has_weight");
        this.hasPort = result.getBoolean("has_port");
        this.hasFlag = result.getBoolean("has_flag");
        this.hasTag = result.getBoolean("has_tag");
        this.paramIp = result.getBoolean("param_ip");
    }

    public boolean hasPriority() {
        return this.hasPriority;
    }

    public boolean hasWeight() {
        return this.hasWeight;
    }

    public boolean hasPort() {
        return this.hasPort;
    }

    public boolean hasFlag() {
        return this.hasFlag;
    }

    public boolean hasTag() {
        return this.hasTag;
    }

    public boolean isParamIp() {
        return this.paramIp;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.description = in.readUTF();
        this.hasPriority = in.readBoolean();
        this.hasWeight = in.readBoolean();
        this.hasPort = in.readBoolean();
        this.hasFlag = in.readBoolean();
        this.hasTag = in.readBoolean();
        this.paramIp = in.readBoolean();
    }

    @Override
    public String toStringImpl() {
        return this.description;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeUTF(this.description);
        out.writeBoolean(this.hasPriority);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_72) >= 0) {
            out.writeBoolean(this.hasWeight);
            out.writeBoolean(this.hasPort);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_86_0) >= 0) {
            out.writeBoolean(this.hasFlag);
            out.writeBoolean(this.hasTag);
        }
        out.writeBoolean(this.paramIp);
    }
}

