/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.dns;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.AddressFamily;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.CachedObjectStringKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Dumpable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.dns.Record;
import com.aoindustries.aoserv.client.dns.RecordType;
import com.aoindustries.aoserv.client.dns.RecordTypeTable;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

public final class Zone
extends CachedObjectStringKey<Zone>
implements Removable,
Dumpable {
    static final int COLUMN_ZONE = 0;
    static final int COLUMN_PACKAGE = 2;
    static final String COLUMN_ZONE_name = "zone";
    public static final int DEFAULT_TTL = 3600;
    public static final int MAX_LINE_LENGTH = 255;
    public static final String API_ZONE = "aoindustries.com.";
    public static final String DEFAULT_HOSTMASTER = "hostmaster.aoindustries.com.";
    public static final int DEFAULT_MX_PRIORITY = 10;
    public static final short DEFAULT_CAA_FLAG = 0;
    public static final String DEFAULT_CAA_TAG = "issue";
    public static final String DEFAULT_CAA_VALUE = ";";
    private String file;
    private Account.Name packageName;
    private String hostmaster;
    private long serial;
    private int ttl;

    @Deprecated
    public Zone() {
    }

    public int addDnsRecord(String domain, RecordType type, int priority, int weight, int port, short flag, String tag, String destination, int ttl) throws IOException, SQLException {
        return this.table.getConnector().getDns().getRecord().addDnsRecord(this, domain, type, priority, weight, port, flag, tag, destination, ttl);
    }

    @Override
    public void dump(PrintWriter out) throws SQLException, IOException {
        this.printZoneFile(out);
    }

    public RecordType[] getAllowedTypes() throws IOException, SQLException {
        RecordTypeTable tt = this.table.getConnector().getDns().getRecordType();
        if (this.isArpa()) {
            RecordType[] types = new RecordType[]{tt.get("NS"), tt.get("PTR")};
            return types;
        }
        RecordType[] types = new RecordType[]{tt.get("A"), tt.get("AAAA"), tt.get("CAA"), tt.get("CNAME"), tt.get("MX"), tt.get("NS"), tt.get("SRV"), tt.get("TXT")};
        return types;
    }

    public static String getArpaZoneForIpAddress(InetAddress ip, String netmask) throws IllegalArgumentException {
        AddressFamily addressFamily = ip.getAddressFamily();
        switch (addressFamily) {
            case INET: {
                String ipStr = ip.toString();
                if ("255.255.255.0".equals(netmask)) {
                    int pos = ipStr.indexOf(46);
                    int oct1 = Integer.parseInt(ipStr.substring(0, pos));
                    int pos2 = ipStr.indexOf(46, pos + 1);
                    int oct2 = Integer.parseInt(ipStr.substring(pos + 1, pos2));
                    pos = ipStr.indexOf(46, pos2 + 1);
                    int oct3 = Integer.parseInt(ipStr.substring(pos2 + 1, pos));
                    return oct3 + "." + oct2 + "." + oct1 + ".in-addr.arpa";
                }
                if ("255.255.255.128".equals(netmask)) {
                    int pos = ipStr.indexOf(46);
                    int oct1 = Integer.parseInt(ipStr.substring(0, pos));
                    int pos2 = ipStr.indexOf(46, pos + 1);
                    int oct2 = Integer.parseInt(ipStr.substring(pos + 1, pos2));
                    pos = ipStr.indexOf(46, pos2 + 1);
                    int oct3 = Integer.parseInt(ipStr.substring(pos2 + 1, pos));
                    int oct4 = Integer.parseInt(ipStr.substring(pos + 1));
                    return "subnet" + (oct4 & 0x80) + "." + oct3 + "." + oct2 + "." + oct1 + ".in-addr.arpa";
                }
                throw new IllegalArgumentException("Unsupported netmask: " + netmask);
            }
            case INET6: {
                throw new IllegalArgumentException("IPv6 not yet implemented: " + ip);
            }
        }
        throw new AssertionError((Object)("Unexpected address family: " + addressFamily));
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.file;
            }
            case 2: {
                return this.packageName;
            }
            case 3: {
                return this.hostmaster;
            }
            case 4: {
                return this.serial;
            }
            case 5: {
                return this.ttl;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public static long getCurrentSerial() {
        GregorianCalendar gcal = new GregorianCalendar(Type.DATE_TIME_ZONE);
        return (long)gcal.get(1) * 1000000L + (long)((gcal.get(2) + 1) * 10000) + (long)(gcal.get(5) * 100) + 1L;
    }

    public List<Record> getRecords() throws IOException, SQLException {
        return this.table.getConnector().getDns().getRecord().getRecords(this);
    }

    public List<Record> getRecords(String domain, RecordType type) throws IOException, SQLException {
        return this.table.getConnector().getDns().getRecord().getRecords(this, domain, type);
    }

    public String getFile() {
        return this.file;
    }

    public String getHostmaster() {
        return this.hostmaster;
    }

    public Package getPackage() throws SQLException, IOException {
        Package obj = this.table.getConnector().getBilling().getPackage().get(this.packageName);
        if (obj == null) {
            throw new SQLException("Unable to find Package: " + this.packageName);
        }
        return obj;
    }

    public long getSerial() {
        return this.serial;
    }

    public int getTtl() {
        return this.ttl;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DNS_ZONES;
    }

    public String getZone() {
        return this.pkey;
    }

    public String getZoneFile() throws SQLException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout);
        this.printZoneFile(out);
        out.flush();
        return new String(bout.toByteArray());
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getString(1);
            this.file = result.getString(2);
            this.packageName = Account.Name.valueOf(result.getString(3));
            this.hostmaster = result.getString(4);
            this.serial = result.getLong(5);
            this.ttl = result.getInt(6);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isArpa() {
        return this.pkey.length() > 13 && ".in-addr.arpa".equals(this.pkey.substring(this.pkey.length() - 13));
    }

    private static void printLine(StringBuilder line, PrintWriter out) {
        if (line.length() > 255) {
            throw new IllegalStateException("Line too long: " + line);
        }
        out.print(line);
        out.print('\n');
        line.setLength(0);
    }

    private static void printRecord(String linePrefix, StringBuilder line, PrintWriter out, String domain, int ttl, int recordTtl, String type, int priority, int weight, int port, short flag, String tag, String destination) {
        int d;
        String s;
        line.append(linePrefix);
        line.append(domain);
        int count = Math.max(1, 24 - domain.length());
        for (int d2 = 0; d2 < count; ++d2) {
            line.append(' ');
        }
        if (recordTtl != -1) {
            s = String.valueOf(recordTtl);
            line.append(s);
            count = Math.max(1, 24 - s.length());
        } else {
            s = String.valueOf(ttl);
            line.append(s);
            count = Math.max(1, 24 - s.length());
        }
        for (d = 0; d < count; ++d) {
            line.append(' ');
        }
        line.append("IN   ");
        line.append(type);
        count = Math.max(1, 8 - type.length());
        for (d = 0; d < count; ++d) {
            line.append(' ');
        }
        if (priority != -1) {
            line.append(priority);
            line.append(' ');
        }
        if (weight != -1) {
            line.append(weight);
            line.append(' ');
        }
        if (port != -1) {
            line.append(port);
            line.append(' ');
        }
        if (flag != -1) {
            line.append(flag);
            line.append(' ');
        }
        if (tag != null) {
            line.append(tag);
            line.append(' ');
        }
        if (type.equals("CAA") || type.equals("TXT")) {
            String txt = Record.cleanTxt(destination);
            int oneLineLength = line.length() + 1 + txt.length() + 1;
            if (oneLineLength <= 255) {
                line.append('\"').append(txt).append('\"');
                Zone.printLine(line, out);
            } else {
                line.append('(');
                Zone.printLine(line, out);
                int charsPerLine = 255 - (linePrefix.length() + 2);
                for (int lineStart = 0; lineStart < txt.length(); lineStart += charsPerLine) {
                    line.append(linePrefix).append('\"').append(txt, lineStart, Math.min(txt.length(), lineStart + charsPerLine)).append('\"');
                    Zone.printLine(line, out);
                }
                line.append(linePrefix).append(')');
                Zone.printLine(line, out);
            }
        } else {
            line.append(destination);
            Zone.printLine(line, out);
        }
    }

    public void printZoneFile(PrintWriter out) throws SQLException, IOException {
        StringBuilder line = new StringBuilder();
        List<Record> records = this.getRecords();
        line.append("$TTL    ").append(this.ttl);
        Zone.printLine(line, out);
        if (!this.isArpa()) {
            line.append("$ORIGIN ").append(this.pkey);
            Zone.printLine(line, out);
        }
        line.append("@                       ").append(this.ttl).append(" IN   SOA     ");
        Record firstNameserver = null;
        for (Record rec : records) {
            if (!rec.getType().getType().equals("NS")) continue;
            firstNameserver = rec;
            break;
        }
        line.append(firstNameserver == null ? "ns1.aoindustries.com." : firstNameserver.getDestination());
        line.append("   ").append(this.hostmaster).append(" (");
        Zone.printLine(line, out);
        line.append("                                ").append(this.serial).append(" ; serial");
        Zone.printLine(line, out);
        line.append("                                3600    ; refresh");
        Zone.printLine(line, out);
        line.append("                                600     ; retry");
        Zone.printLine(line, out);
        line.append("                                1814400 ; expiry");
        Zone.printLine(line, out);
        line.append("                                300     ; minimum");
        Zone.printLine(line, out);
        line.append("                                )");
        Zone.printLine(line, out);
        if (firstNameserver == null) {
            line.append("; No name servers configured, using the defaults");
            Zone.printLine(line, out);
            Zone.printRecord("", line, out, "@", this.ttl, -1, "NS", -1, -1, -1, (short)-1, null, "ns1.aoindustries.com.");
            Zone.printRecord("", line, out, "@", this.ttl, -1, "NS", -1, -1, -1, (short)-1, null, "ns2.aoindustries.com.");
            Zone.printRecord("", line, out, "@", this.ttl, -1, "NS", -1, -1, -1, (short)-1, null, "ns3.aoindustries.com.");
            Zone.printRecord("", line, out, "@", this.ttl, -1, "NS", -1, -1, -1, (short)-1, null, "ns4.aoindustries.com.");
        }
        int len = records.size();
        for (int c = 0; c < len; ++c) {
            Record rec = records.get(c);
            boolean hasConflictAbove = false;
            for (int d = 0; d < c; ++d) {
                if (!rec.hasConflict(records.get(d))) continue;
                hasConflictAbove = true;
                break;
            }
            Zone.printRecord(hasConflictAbove ? "; Disabled due to conflict: " : "", line, out, rec.getDomain(), this.ttl, rec.getTtl(), rec.getType_type(), rec.getPriority(), rec.getWeight(), rec.getPort(), rec.getFlag(), rec.getTag(), rec.getDestination());
            if (hasConflictAbove) continue;
            boolean hasConflictBelow = false;
            for (int d = c + 1; d < len; ++d) {
                if (!rec.hasConflict(records.get(d))) continue;
                hasConflictBelow = true;
                break;
            }
            if (!hasConflictBelow) continue;
            line.append("; Some records below have been disabled due to conflict with previous record");
            Zone.printLine(line, out);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readUTF().intern();
            this.file = in.readUTF();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.hostmaster = in.readUTF().intern();
            this.serial = in.readLong();
            this.ttl = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<Zone>> getCannotRemoveReasons() {
        ArrayList<CannotRemoveReason<Zone>> reasons = new ArrayList<CannotRemoveReason<Zone>>();
        if (this.pkey.equals(API_ZONE)) {
            reasons.add(new CannotRemoveReason<Zone>("Not allowed to remove the API Zone: aoindustries.com.", this));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.DNS_ZONES, this.pkey});
    }

    public void setTtl(int ttl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_DNS_ZONE_TTL, this.pkey, ttl);
        this.ttl = ttl;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeUTF(this.file);
        out.writeUTF(this.packageName.toString());
        out.writeUTF(this.hostmaster);
        out.writeLong(this.serial);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_127) >= 0) {
            out.writeCompressedInt(this.ttl);
        }
    }
}

