/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.dns;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableStringKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.dns.TopLevelDomain;
import com.aoindustries.aoserv.client.dns.Zone;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class ZoneTable
extends CachedTableStringKey<Zone> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("zone", true)};

    ZoneTable(AoservConnector connector) {
        super(connector, Zone.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Zone get(String zone) throws IOException, SQLException {
        return (Zone)this.getUniqueRow(0, zone);
    }

    private List<DomainName> getTopLevelDomains() throws IOException, SQLException {
        List tlds = this.connector.getDns().getTopLevelDomain().getRows();
        ArrayList<DomainName> names = new ArrayList<DomainName>(tlds.size());
        for (TopLevelDomain tld : tlds) {
            names.add(tld.getDomain());
        }
        return names;
    }

    public void addDnsZone(Package packageObj, String zone, InetAddress ip, int ttl) throws IOException, SQLException {
        this.connector.requestUpdateInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.DNS_ZONES, packageObj.getName(), zone, ip, ttl});
    }

    public boolean checkDnsZone(String zone) throws IOException, SQLException {
        return ZoneTable.checkDnsZone(zone, this.getTopLevelDomains());
    }

    public static boolean checkDnsZone(String zone, List<DomainName> tlds) {
        int zoneLen = zone.length();
        String shortestName = null;
        int len = tlds.size();
        for (int c = 0; c < len; ++c) {
            DomainName o = tlds.get(c);
            String tld = '.' + o.toString() + '.';
            int tldLen = tld.length();
            if (tldLen >= zoneLen || !zone.substring(zoneLen - tldLen).equals(tld)) continue;
            String name = zone.substring(0, zoneLen - tldLen);
            if (shortestName != null && name.length() >= shortestName.length()) continue;
            shortestName = name;
        }
        if (shortestName != null) {
            return ZoneTable.isValidHostnamePart(shortestName);
        }
        return false;
    }

    public String getZoneForHostname(String hostname) throws IllegalArgumentException, IOException, SQLException {
        return ZoneTable.getZoneForHostname(hostname, this.getTopLevelDomains());
    }

    public static String getZoneForHostname(String hostname, List<DomainName> tlds) throws IllegalArgumentException {
        int hlen = hostname.length();
        if (hlen > 0 && hostname.charAt(hlen - 1) == '.') {
            hostname = hostname.substring(0, --hlen);
        }
        String longestTld = null;
        int tldlen = tlds.size();
        for (int i = 0; i < tldlen; ++i) {
            DomainName o = tlds.get(i);
            String tld = '.' + o.toString();
            int len = tld.length();
            if (hlen < len || !hostname.substring(hlen - len).equals(tld) || longestTld != null && tld.length() <= longestTld.length()) continue;
            longestTld = tld;
        }
        if (longestTld == null) {
            throw new IllegalArgumentException("Unable to determine top level domain for hostname: " + hostname);
        }
        String zone = hostname.substring(0, hlen - longestTld.length());
        int startpos = zone.lastIndexOf(46);
        if (startpos >= 0) {
            zone = zone.substring(startpos + 1);
        }
        return zone + longestTld + ".";
    }

    public List<Zone> getDnsZones(Package packageObj) throws IOException, SQLException {
        return this.getIndexedRows(2, packageObj.getName());
    }

    public static DomainName getHostTld(DomainName hostname, List<DomainName> tlds) throws IllegalArgumentException {
        String hostnameStr = hostname.toLowerCase();
        int hostnameLen = hostnameStr.length();
        for (DomainName o : tlds) {
            String tld = '.' + o.toLowerCase();
            int tldLen = tld.length();
            if (hostnameLen <= tldLen || !hostnameStr.endsWith(tld)) continue;
            String name = hostnameStr.substring(0, hostnameLen - tldLen);
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                name = name.substring(pos + 1);
            }
            try {
                return DomainName.valueOf((String)(name + tld));
            }
            catch (ValidationException e) {
                throw new IllegalArgumentException(e.getLocalizedMessage(), e);
            }
        }
        throw new IllegalArgumentException("Unable to determine the host.tld format of " + hostname);
    }

    public DomainName getHostTld(DomainName hostname) throws IllegalArgumentException, IOException, SQLException {
        return ZoneTable.getHostTld(hostname, this.getTopLevelDomains());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.DNS_ZONES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_dns_zone")) {
            if (Aosh.checkParamCount("add_dns_zone", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().addDnsZone(Aosh.parseAccountingCode(args[1], "package"), args[2], Aosh.parseInetAddress(args[3], "ip_address"), Aosh.parseInt(args[4], "ttl"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_dns_zone")) {
            if (Aosh.checkParamCount("check_dns_zone", args, 1, (PrintWriter)err)) {
                try {
                    this.connector.getSimpleClient().checkDnsZone(args[1]);
                    out.println("true");
                }
                catch (IllegalArgumentException iae) {
                    out.print("aosh: check_dns_zone: ");
                    out.println(iae.getMessage());
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_dns_zone_available")) {
            if (Aosh.checkParamCount("is_dns_zone_available", args, 1, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isDnsZoneAvailable(args[1]));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_dns_zone_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("print_zone_file")) {
            if (Aosh.checkParamCount("print_zone_file", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().printZoneFile(args[1], (PrintWriter)out);
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_dns_zone")) {
            if (Aosh.checkParamCount("remove_dns_zone", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeDnsZone(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_dns_zone_ttl") && Aosh.checkParamCount("remove_dns_zone", args, 2, (PrintWriter)err)) {
            this.connector.getSimpleClient().setDnsZoneTtl(args[1], Aosh.parseInt(args[2], "ttl"));
        }
        return false;
    }

    public boolean isDnsZoneAvailable(String zone) throws IOException, SQLException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_DNS_ZONE_AVAILABLE, zone);
    }

    public static boolean isValidHostnamePart(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        if (name.charAt(0) == '-') {
            return false;
        }
        int numCount = 0;
        for (int c = 0; c < len; ++c) {
            char ch = name.charAt(c);
            if (!(ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-')) {
                return false;
            }
            if (ch < '0' || ch > '9') continue;
            ++numCount;
        }
        return numCount != len;
    }
}

