/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.BlackholeAddress;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.Forwarding;
import com.aoindustries.aoserv.client.email.InboxAddress;
import com.aoindustries.aoserv.client.email.List;
import com.aoindustries.aoserv.client.email.ListAddress;
import com.aoindustries.aoserv.client.email.MajordomoList;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.email.Pipe;
import com.aoindustries.aoserv.client.email.PipeAddress;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class Address
extends CachedObjectIntegerKey<Address>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_DOMAIN = 2;
    static final String COLUMN_DOMAIN_name = "domain";
    static final String COLUMN_ADDRESS_name = "address";
    private String address;
    private int domain;

    @Deprecated
    public Address() {
    }

    public int addEmailForwarding(Email destination) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getForwarding().addEmailForwarding(this, destination);
    }

    public String getAddress() {
        return this.address;
    }

    public BlackholeAddress getBlackholeEmailAddress() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getBlackholeAddress().get(this.pkey);
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.address;
            }
            case 2: {
                return this.domain;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Domain getDomain() throws SQLException, IOException {
        Domain domainObject = this.table.getConnector().getEmail().getDomain().get(this.domain);
        if (domainObject == null) {
            throw new SQLException("Unable to find EmailDomain: " + this.domain);
        }
        return domainObject;
    }

    public java.util.List<Forwarding> getEmailForwardings() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getForwarding().getEmailForwardings(this);
    }

    public java.util.List<Forwarding> getEnabledEmailForwardings() throws SQLException, IOException {
        return this.table.getConnector().getEmail().getForwarding().getEnabledEmailForwardings(this);
    }

    public Forwarding getEmailForwarding(Email destination) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getForwarding().getEmailForwarding(this, destination);
    }

    public java.util.List<List> getEmailLists() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getListAddress().getEmailLists(this);
    }

    public java.util.List<ListAddress> getEmailListAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getListAddress().getEmailListAddresses(this);
    }

    public java.util.List<ListAddress> getEnabledEmailListAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getListAddress().getEnabledEmailListAddresses(this);
    }

    public ListAddress getEmailListAddress(List list) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getListAddress().getEmailListAddress(this, list);
    }

    public java.util.List<Pipe> getEmailPipes() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipeAddress().getEmailPipes(this);
    }

    public java.util.List<PipeAddress> getEmailPipeAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipeAddress().getEmailPipeAddresses(this);
    }

    public java.util.List<PipeAddress> getEnabledEmailPipeAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipeAddress().getEnabledEmailPipeAddresses(this);
    }

    public PipeAddress getEmailPipeAddress(Pipe pipe) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getPipeAddress().getEmailPipeAddress(this, pipe);
    }

    public java.util.List<UserServer> getLinuxServerAccounts() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getInboxAddress().getLinuxServerAccounts(this);
    }

    public java.util.List<InboxAddress> getLinuxAccAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getInboxAddress().getLinuxAccAddresses(this);
    }

    public InboxAddress getLinuxAccAddress(UserServer lsa) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getInboxAddress().getLinuxAccAddress(this, lsa);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_ADDRESSES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.address = result.getString(2);
        this.domain = result.getInt(3);
    }

    public boolean isUsed() throws IOException, SQLException {
        return this.getBlackholeEmailAddress() != null || !this.getEmailForwardings().isEmpty() || !this.getEmailListAddresses().isEmpty() || !this.getEmailPipeAddresses().isEmpty() || !this.getLinuxAccAddresses().isEmpty();
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.address = in.readUTF();
        this.domain = in.readCompressedInt();
    }

    public java.util.List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        Domain ed;
        ArrayList reasons = new ArrayList();
        BlackholeAddress bea = this.getBlackholeEmailAddress();
        if (bea != null) {
            reasons.addAll(bea.getCannotRemoveReasons());
        }
        for (Forwarding ef : this.getEmailForwardings()) {
            reasons.addAll(ef.getCannotRemoveReasons());
        }
        for (ListAddress ela : this.table.getConnector().getEmail().getListAddress().getEmailListAddresses(this)) {
            reasons.addAll(ela.getCannotRemoveReasons());
        }
        for (PipeAddress epa : this.getEmailPipeAddresses()) {
            reasons.addAll(epa.getCannotRemoveReasons());
        }
        for (InboxAddress laa : this.getLinuxAccAddresses()) {
            reasons.addAll(laa.getCannotRemoveReasons());
        }
        for (MajordomoList ml : this.table.getConnector().getEmail().getMajordomoList().getRows()) {
            if (ml.getOwnerListAddress_id() != this.pkey && ml.getListOwnerAddress_id() != this.pkey && ml.getListApprovalAddress_id() != this.pkey) continue;
            ed = ml.getMajordomoServer().getDomain();
            reasons.add(new CannotRemoveReason<MajordomoList>("Used by Majordomo list " + ml.getName() + '@' + ed.getDomain() + " on " + ed.getLinuxServer().getHostname(), ml));
        }
        for (MajordomoServer ms : this.table.getConnector().getEmail().getMajordomoServer().getRows()) {
            if (ms.getOwnerMajordomoAddress_id() != this.pkey && ms.getMajordomoOwnerAddress_id() != this.pkey) continue;
            ed = ms.getDomain();
            reasons.add(new CannotRemoveReason<MajordomoServer>("Used by Majordomo server " + ed.getDomain() + " on " + ed.getLinuxServer().getHostname(), ms));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_ADDRESSES, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.address + '@' + this.getDomain().getDomain().toString();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.address);
        out.writeCompressedInt(this.domain);
    }
}

