/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class AddressTable
extends CachedTableIntegerKey<Address> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("domain.domain", true), new AoservTable.OrderBy("domain.ao_server.hostname", true), new AoservTable.OrderBy("address", true)};

    AddressTable(AoservConnector connector) {
        super(connector, Address.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addEmailAddress(String address, Domain domainObject) throws SQLException, IOException {
        ValidationResult result = Email.validate((String)address, (DomainName)domainObject.getDomain());
        if (!result.isValid()) {
            throw new SQLException("Invalid email address: " + result.toString());
        }
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.EMAIL_ADDRESSES, address, domainObject.getPkey()});
    }

    @Override
    public Address get(int pkey) throws IOException, SQLException {
        return (Address)this.getUniqueRow(0, pkey);
    }

    public Address getEmailAddress(String address, Domain domain) throws IOException, SQLException {
        for (Address emailAddress : domain.getEmailAddresses()) {
            if (!emailAddress.getAddress().equals(address)) continue;
            return emailAddress;
        }
        return null;
    }

    List<Address> getEmailAddresses(Domain domain) throws IOException, SQLException {
        return this.getIndexedRows(2, domain.getPkey());
    }

    public List<Address> getEmailAddresses(Server ao) throws IOException, SQLException {
        int aoPkey = ao.getPkey();
        List addresses = this.getRows();
        int len = addresses.size();
        ArrayList<Address> matches = new ArrayList<Address>(len);
        for (int c = 0; c < len; ++c) {
            Address address = (Address)addresses.get(c);
            if (address.getDomain().getLinuxServer_host_id() != aoPkey) continue;
            matches.add(address);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_ADDRESSES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("check_email_address")) {
            if (Aosh.checkMinParamCount("check_email_address", args, 1, (PrintWriter)err)) {
                for (int c = 1; c < args.length; ++c) {
                    String addr = args[c];
                    ValidationResult validationResult = Email.validate((String)addr);
                    if (args.length > 2) {
                        out.print(addr);
                        out.print(": ");
                    }
                    out.println(validationResult.isValid());
                    out.flush();
                    if (validationResult.isValid()) continue;
                    err.print("aosh: check_email_address: invalid email address: ");
                    if (args.length > 2) {
                        err.print(addr);
                        err.print(": ");
                    }
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_email_address")) {
            if (Aosh.checkMinParamCount("remove_email_address", args, 2, (PrintWriter)err)) {
                if ((args.length & 1) != 0) {
                    for (int c = 1; c < args.length; c += 2) {
                        String addr = args[c];
                        int pos = addr.indexOf(64);
                        if (pos == -1) {
                            err.print("aosh: remove_email_address: invalid email address: ");
                            err.println(addr);
                            err.flush();
                            continue;
                        }
                        this.connector.getSimpleClient().removeEmailAddress(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), args[c + 1]);
                    }
                } else {
                    throw new IllegalArgumentException("aosh: remove_email_address: must have even number of parameters.");
                }
            }
            return true;
        }
        return false;
    }
}

