/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.AttachmentType;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class AttachmentBlock
extends CachedObjectIntegerKey<AttachmentBlock>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_LINUX_SERVER_ACCOUNT = 1;
    static final String COLUMN_LINUX_SERVER_ACCOUNT_name = "linux_server_account";
    static final String COLUMN_EXTENSION_name = "extension";
    private int linuxServerAccount;
    private String extension;

    @Deprecated
    public AttachmentBlock() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.linuxServerAccount;
            }
            case 2: {
                return this.extension;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        UserServer lsa = this.table.getConnector().getLinux().getUserServer().get(this.linuxServerAccount);
        if (lsa == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.linuxServerAccount);
        }
        return lsa;
    }

    public AttachmentType getEmailAttachmentType() throws SQLException, IOException {
        AttachmentType eat = this.table.getConnector().getEmail().getAttachmentType().get(this.extension);
        if (eat == null) {
            throw new SQLException("Unable to find EmailAttachmentType: " + this.extension);
        }
        return eat;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_ATTACHMENT_BLOCKS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.linuxServerAccount = result.getInt(2);
        this.extension = result.getString(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.linuxServerAccount = in.readCompressedInt();
        this.extension = in.readUTF().intern();
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws SQLException, IOException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_ATTACHMENT_BLOCKS, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getLinuxServerAccount().toStringImpl() + "->" + this.extension;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.linuxServerAccount);
        out.writeUTF(this.extension);
    }
}

