/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class BlackholeAddress
extends CachedObjectIntegerKey<BlackholeAddress>
implements Removable {
    static final int COLUMN_EMAIL_ADDRESS = 0;
    static final String COLUMN_EMAIL_ADDRESS_name = "email_address";

    @Deprecated
    public BlackholeAddress() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Address getEmailAddress() throws SQLException, IOException {
        Address emailAddressObject = this.table.getConnector().getEmail().getAddress().get(this.pkey);
        if (emailAddressObject == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.pkey);
        }
        return emailAddressObject;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BLACKHOLE_EMAIL_ADDRESSES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.BLACKHOLE_EMAIL_ADDRESSES, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getEmailAddress().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
    }
}

