/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.BlackholeAddress;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class BlackholeAddressTable
extends CachedTableIntegerKey<BlackholeAddress> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("email_address.domain.domain", true), new AoservTable.OrderBy("email_address.domain.ao_server.hostname", true), new AoservTable.OrderBy("email_address.address", true)};

    BlackholeAddressTable(AoservConnector connector) {
        super(connector, BlackholeAddress.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public BlackholeAddress get(int address) throws IOException, SQLException {
        return (BlackholeAddress)this.getUniqueRow(0, address);
    }

    public List<BlackholeAddress> getBlackholeEmailAddresses(Server ao) throws IOException, SQLException {
        int aoPkey = ao.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<BlackholeAddress> matches = new ArrayList<BlackholeAddress>(len);
        for (int c = 0; c < len; ++c) {
            BlackholeAddress blackhole = (BlackholeAddress)cached.get(c);
            if (blackhole.getEmailAddress().getDomain().getLinuxServer_host_id() != aoPkey) continue;
            matches.add(blackhole);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BLACKHOLE_EMAIL_ADDRESSES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("remove_blackhole_email_address")) {
            if (Aosh.checkParamCount("remove_blackhole_email_address", args, 2, (PrintWriter)err)) {
                String addr = args[1];
                int pos = addr.indexOf(64);
                if (pos == -1) {
                    err.print("aosh: remove_blackhole_email_address: invalid email address: ");
                    err.println(addr);
                    err.flush();
                } else {
                    this.connector.getSimpleClient().removeBlackholeEmailAddress(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), args[2]);
                }
            }
            return true;
        }
        return false;
    }
}

