/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.email.CyrusImapdServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

public final class CyrusImapdBind
extends CachedObjectIntegerKey<CyrusImapdBind> {
    static final int COLUMN_NET_BIND = 0;
    static final int COLUMN_CYRUS_IMAPD_SERVER = 1;
    static final int COLUMN_SSL_CERTIFICATE = 3;
    static final String COLUMN_NET_BIND_name = "net_bind";
    private int cyrusImapdServer;
    private DomainName servername;
    private int certificate;
    private Boolean allowPlaintextAuth;

    @Deprecated
    public CyrusImapdBind() {
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        CyrusImapdServer server = this.getCyrusImapdServer();
        Bind bind = this.getNetBind();
        return server.toStringImpl() + '|' + bind.toStringImpl();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.cyrusImapdServer;
            }
            case 2: {
                return this.servername;
            }
            case 3: {
                return this.certificate == -1 ? null : Integer.valueOf(this.certificate);
            }
            case 4: {
                return this.allowPlaintextAuth;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.CYRUS_IMAPD_BINDS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.cyrusImapdServer = result.getInt(pos++);
            this.servername = DomainName.valueOf((String)result.getString(pos++));
            this.certificate = result.getInt(pos++);
            if (result.wasNull()) {
                this.certificate = -1;
            }
            this.allowPlaintextAuth = result.getBoolean(pos++);
            if (result.wasNull()) {
                this.allowPlaintextAuth = null;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.cyrusImapdServer = in.readCompressedInt();
            this.servername = DomainName.valueOf((String)in.readNullUTF());
            this.certificate = in.readCompressedInt();
            this.allowPlaintextAuth = in.readNullBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.cyrusImapdServer);
        out.writeNullUTF(Objects.toString(this.servername, null));
        out.writeCompressedInt(this.certificate);
        out.writeNullBoolean(this.allowPlaintextAuth);
    }

    public Bind getNetBind() throws SQLException, IOException {
        Bind obj = this.table.getConnector().getNet().getBind().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find NetBind: " + this.pkey);
        }
        return obj;
    }

    public CyrusImapdServer getCyrusImapdServer() throws SQLException, IOException {
        CyrusImapdServer obj = this.table.getConnector().getEmail().getCyrusImapdServer().get(this.cyrusImapdServer);
        if (obj == null) {
            throw new SQLException("Unable to find CyrusImapd: " + this.cyrusImapdServer);
        }
        return obj;
    }

    public DomainName getServername() {
        return this.servername;
    }

    public Certificate getCertificate() throws SQLException, IOException {
        if (this.certificate == -1) {
            return null;
        }
        return this.table.getConnector().getPki().getCertificate().get(this.certificate);
    }

    public Boolean getAllowPlaintextAuth() {
        return this.allowPlaintextAuth;
    }
}

