/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.math.SafeMath;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.email.CyrusImapdBind;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.Host;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public final class CyrusImapdServer
extends CachedObjectIntegerKey<CyrusImapdServer> {
    static final int COLUMN_AO_SERVER = 0;
    static final int COLUMN_SIEVE_NET_BIND = 1;
    static final int COLUMN_CERTIFICATE = 3;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    public static final boolean DEFAULT_ALLOW_PLAINTEXT_AUTH = false;
    public static final float DEFAULT_DELETE_DURATION = Float.NaN;
    public static final TimeUnit DEFAULT_DELETE_DURATION_UNIT = null;
    public static final float DEFAULT_EXPIRE_DURATION = 3.0f;
    public static final TimeUnit DEFAULT_EXPIRE_DURATION_UNIT = TimeUnit.DAYS;
    public static final float DEFAULT_EXPUNGE_DURATION = 3.0f;
    public static final TimeUnit DEFAULT_EXPUNGE_DURATION_UNIT = TimeUnit.DAYS;
    private int sieveNetBind;
    private DomainName servername;
    private int certificate;
    private boolean allowPlaintextAuth;
    private float deleteDuration;
    private TimeUnit deleteDurationUnit;
    private float expireDuration;
    private TimeUnit expireDurationUnit;
    private float expungeDuration;
    private TimeUnit expungeDurationUnit;

    @Deprecated
    public CyrusImapdServer() {
    }

    @Override
    public String toStringImpl() throws IOException, SQLException {
        return "Cyrus IMAPD @ " + (this.servername != null ? this.servername : this.getLinuxServer().getHostname());
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.sieveNetBind == -1 ? null : Integer.valueOf(this.sieveNetBind);
            }
            case 2: {
                return this.servername;
            }
            case 3: {
                return this.certificate;
            }
            case 4: {
                return this.allowPlaintextAuth;
            }
            case 5: {
                return Float.valueOf(this.deleteDuration);
            }
            case 6: {
                return this.deleteDurationUnit == null ? null : String.valueOf(this.deleteDurationUnit.getSuffix());
            }
            case 7: {
                return Float.valueOf(this.expireDuration);
            }
            case 8: {
                return this.expireDurationUnit == null ? null : String.valueOf(this.expireDurationUnit.getSuffix());
            }
            case 9: {
                return Float.valueOf(this.expungeDuration);
            }
            case 10: {
                return this.expungeDurationUnit == null ? null : String.valueOf(this.expungeDurationUnit.getSuffix());
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.CYRUS_IMAPD_SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.sieveNetBind = result.getInt(pos++);
            if (result.wasNull()) {
                this.sieveNetBind = -1;
            }
            this.servername = DomainName.valueOf((String)result.getString(pos++));
            this.certificate = result.getInt(pos++);
            this.allowPlaintextAuth = result.getBoolean(pos++);
            this.deleteDuration = result.getFloat(pos++);
            if (result.wasNull()) {
                this.deleteDuration = Float.NaN;
            }
            this.deleteDurationUnit = TimeUnit.getFromSuffix(result.getString(pos++));
            this.expireDuration = result.getFloat(pos++);
            this.expireDurationUnit = TimeUnit.getFromSuffix(result.getString(pos++));
            this.expungeDuration = result.getFloat(pos++);
            if (result.wasNull()) {
                this.expungeDuration = Float.NaN;
            }
            this.expungeDurationUnit = TimeUnit.getFromSuffix(result.getString(pos++));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.sieveNetBind = in.readCompressedInt();
            this.servername = DomainName.valueOf((String)in.readNullUTF());
            this.certificate = in.readCompressedInt();
            this.allowPlaintextAuth = in.readBoolean();
            this.deleteDuration = in.readFloat();
            this.deleteDurationUnit = (TimeUnit)in.readNullEnum(TimeUnit.class);
            this.expireDuration = in.readFloat();
            this.expireDurationUnit = (TimeUnit)in.readNullEnum(TimeUnit.class);
            this.expungeDuration = in.readFloat();
            this.expungeDurationUnit = (TimeUnit)in.readNullEnum(TimeUnit.class);
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.sieveNetBind);
        out.writeNullUTF(Objects.toString(this.servername, null));
        out.writeCompressedInt(this.certificate);
        out.writeBoolean(this.allowPlaintextAuth);
        out.writeFloat(this.deleteDuration);
        out.writeNullEnum((Enum)this.deleteDurationUnit);
        out.writeFloat(this.expireDuration);
        out.writeNullEnum((Enum)this.expireDurationUnit);
        out.writeFloat(this.expungeDuration);
        out.writeNullEnum((Enum)this.expungeDurationUnit);
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server obj = this.table.getConnector().getLinux().getServer().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find linux.Server: " + this.pkey);
        }
        return obj;
    }

    public Bind getSieveNetBind() throws IOException, SQLException {
        if (this.sieveNetBind == -1) {
            return null;
        }
        Bind nb = this.table.getConnector().getNet().getBind().get(this.sieveNetBind);
        if (nb == null) {
            return null;
        }
        String protocol = nb.getAppProtocol().getProtocol();
        if (!"sieve".equals(protocol)) {
            throw new SQLException("Sieve NetBind is incorrect app_protocol for NetBind #" + nb.getPkey() + ": " + protocol);
        }
        Host server = nb.getHost();
        if (!server.equals(this.getLinuxServer().getHost())) {
            throw new SQLException("Sieve NetBind is not on this server for NetBind #" + nb.getPkey());
        }
        return nb;
    }

    public DomainName getServername() {
        return this.servername;
    }

    public Certificate getCertificate() throws SQLException, IOException {
        return this.table.getConnector().getPki().getCertificate().get(this.certificate);
    }

    public boolean getAllowPlaintextAuth() {
        return this.allowPlaintextAuth;
    }

    public float getDeleteDuration() {
        return this.deleteDuration;
    }

    public TimeUnit getDeleteDurationUnit() {
        return this.deleteDurationUnit;
    }

    public float getExpireDuration() {
        return this.expireDuration;
    }

    public TimeUnit getExpireDurationUnit() {
        return this.expireDurationUnit;
    }

    public float getExpungeDuration() {
        return this.expungeDuration;
    }

    public TimeUnit getExpungeDurationUnit() {
        return this.expungeDurationUnit;
    }

    public List<CyrusImapdBind> getCyrusImapdBinds() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getCyrusImapdBind().getCyrusImapdBinds(this);
    }

    public static enum TimeUnit {
        DAYS('d'){

            @Override
            float convertToDays(float duration) {
                return duration;
            }
        }
        ,
        HOURS('h'){

            @Override
            float convertToDays(float duration) {
                return duration / 24.0f;
            }
        }
        ,
        MINUTES('m'){

            @Override
            float convertToDays(float duration) {
                return duration / 1440.0f;
            }
        }
        ,
        SECONDS('s'){

            @Override
            float convertToDays(float duration) {
                return duration / 86400.0f;
            }
        };

        private static final TimeUnit[] values;
        private final char suffix;

        private static TimeUnit getFromSuffix(String suffix) {
            if (suffix == null) {
                return null;
            }
            if (suffix.length() != 1) {
                throw new IllegalArgumentException("Suffix must be one character: " + suffix);
            }
            char ch = suffix.charAt(0);
            for (TimeUnit value : values) {
                if (ch != value.suffix) continue;
                return value;
            }
            throw new IllegalArgumentException("TimeUnit not found from suffix: " + ch);
        }

        private TimeUnit(char suffix) {
            this.suffix = suffix;
        }

        public char getSuffix() {
            return this.suffix;
        }

        public int getDays(float duration) {
            if (Float.isNaN(duration)) {
                throw new IllegalArgumentException("duration is NaN");
            }
            return SafeMath.castInt((long)Math.round(Math.ceil(this.convertToDays(duration))));
        }

        abstract float convertToDays(float var1);

        static {
            values = TimeUnit.values();
        }
    }
}

