/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.MajordomoServer;
import com.aoindustries.aoserv.client.email.MajordomoVersion;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class Domain
extends CachedObjectIntegerKey<Domain>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 2;
    static final int COLUMN_PACKAGE = 3;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_DOMAIN_name = "domain";
    private DomainName domain;
    private int aoServer;
    private Account.Name packageName;

    @Deprecated
    public Domain() {
    }

    public int addEmailAddress(String address) throws SQLException, IOException {
        return this.table.getConnector().getEmail().getAddress().addEmailAddress(address, this);
    }

    public void addMajordomoServer(UserServer linuxServerAccount, GroupServer linuxServerGroup, MajordomoVersion majordomoVersion) throws IOException, SQLException {
        this.table.getConnector().getEmail().getMajordomoServer().addMajordomoServer(this, linuxServerAccount, linuxServerGroup, majordomoVersion);
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.domain;
            }
            case 2: {
                return this.aoServer;
            }
            case 3: {
                return this.packageName;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public DomainName getDomain() {
        return this.domain;
    }

    public Address getEmailAddress(String address) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getAddress().getEmailAddress(address, this);
    }

    public List<Address> getEmailAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getAddress().getEmailAddresses(this);
    }

    public MajordomoServer getMajordomoServer() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getMajordomoServer().get(this.pkey);
    }

    public Package getPackage() throws SQLException, IOException {
        Package packageObject = this.table.getConnector().getBilling().getPackage().get(this.packageName);
        if (packageObject == null) {
            throw new SQLException("Unable to find Package: " + this.packageName);
        }
        return packageObject;
    }

    public int getLinuxServer_host_id() {
        return this.aoServer;
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server ao = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (ao == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return ao;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_DOMAINS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.domain = DomainName.valueOf((String)result.getString(2));
            this.aoServer = result.getInt(3);
            this.packageName = Account.Name.valueOf(result.getString(4));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.domain = DomainName.valueOf((String)in.readUTF());
            this.aoServer = in.readCompressedInt();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList reasons = new ArrayList();
        MajordomoServer ms = this.getMajordomoServer();
        if (ms != null) {
            Domain ed = ms.getDomain();
            reasons.add(new CannotRemoveReason<MajordomoServer>("Used by Majordomo server " + ed.getDomain() + " on " + ed.getLinuxServer().getHostname(), ms));
        }
        for (Address ea : this.getEmailAddresses()) {
            reasons.addAll(ea.getCannotRemoveReasons());
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_DOMAINS, this.pkey});
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.domain.toString());
        out.writeCompressedInt(this.aoServer);
        out.writeUTF(this.packageName.toString());
    }
}

