/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationResult;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class DomainTable
extends CachedTableIntegerKey<Domain> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("domain", true), new AoservTable.OrderBy("ao_server.hostname", true)};

    DomainTable(AoservConnector connector) {
        super(connector, Domain.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addEmailDomain(DomainName domain, Server ao, Package packageObject) throws SQLException, IOException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.EMAIL_DOMAINS, domain, ao.getPkey(), packageObject.getName()});
    }

    @Override
    public Domain get(int pkey) throws IOException, SQLException {
        return (Domain)this.getUniqueRow(0, pkey);
    }

    public List<Domain> getEmailDomains(Account owner) throws SQLException, IOException {
        Account.Name accounting = owner.getName();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<Domain> matches = new ArrayList<Domain>(len);
        for (int c = 0; c < len; ++c) {
            Domain domain = (Domain)cached.get(c);
            if (!domain.getPackage().getAccount_name().equals(accounting)) continue;
            matches.add(domain);
        }
        return matches;
    }

    public List<Domain> getEmailDomains(Package pack) throws IOException, SQLException {
        return this.getIndexedRows(3, pack.getName());
    }

    public List<Domain> getEmailDomains(Server ao) throws IOException, SQLException {
        return this.getIndexedRows(2, ao.getServer_pkey());
    }

    public Domain getEmailDomain(Server ao, DomainName domain) throws IOException, SQLException {
        List<Domain> cached = this.getEmailDomains(ao);
        int len = cached.size();
        for (int c = 0; c < len; ++c) {
            Domain sd = cached.get(c);
            if (!domain.equals((Object)sd.getDomain())) continue;
            return sd;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_DOMAINS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_email_domain")) {
            if (Aosh.checkParamCount("add_email_domain", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addEmailDomain(Aosh.parseDomainName(args[1], "domain"), args[2], Aosh.parseAccountingCode(args[3], "package")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_email_domain")) {
            if (Aosh.checkParamCount("check_email_domain", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = DomainName.validate((String)args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_email_domain: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_email_domain_available")) {
            if (Aosh.checkParamCount("is_email_domain_available", args, 2, (PrintWriter)err)) {
                try {
                    out.println(this.connector.getSimpleClient().isEmailDomainAvailable(Aosh.parseDomainName(args[1], "domain"), args[2]));
                    out.flush();
                }
                catch (IllegalArgumentException iae) {
                    err.print("aosh: is_email_domain_available: ");
                    err.println(iae.getMessage());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_email_domain")) {
            if (Aosh.checkParamCount("remove_email_domain", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeEmailDomain(Aosh.parseDomainName(args[1], "domain"), args[2]);
            }
            return true;
        }
        return false;
    }

    public boolean isEmailDomainAvailable(Server aoServer, DomainName domain) throws SQLException, IOException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_EMAIL_DOMAIN_AVAILABLE, aoServer.getPkey(), domain);
    }
}

