/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class Forwarding
extends CachedObjectIntegerKey<Forwarding>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_EMAIL_ADDRESS = 1;
    static final String COLUMN_EMAIL_ADDRESS_name = "email_address";
    static final String COLUMN_DESTINATION_name = "destination";
    private int emailAddress;
    private Email destination;

    @Deprecated
    public Forwarding() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.emailAddress;
            }
            case 2: {
                return this.destination;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Email getDestination() {
        return this.destination;
    }

    public Address getEmailAddress() throws SQLException, IOException {
        Address emailAddressObject = this.table.getConnector().getEmail().getAddress().get(this.emailAddress);
        if (emailAddressObject == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.emailAddress);
        }
        return emailAddressObject;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_FORWARDING;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.emailAddress = result.getInt(2);
            this.destination = Email.valueOf((String)result.getString(3));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.emailAddress = in.readCompressedInt();
            this.destination = Email.valueOf((String)in.readUTF());
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_FORWARDING, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getEmailAddress().toStringImpl() + " -> " + this.destination;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.emailAddress);
        out.writeUTF(this.destination.toString());
    }
}

