/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.Forwarding;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ForwardingTable
extends CachedTableIntegerKey<Forwarding> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("email_address.domain.domain", true), new AoservTable.OrderBy("email_address.domain.ao_server.hostname", true), new AoservTable.OrderBy("email_address.address", true), new AoservTable.OrderBy("destination", true)};

    ForwardingTable(AoservConnector connector) {
        super(connector, Forwarding.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addEmailForwarding(Address emailAddressObject, Email destination) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.EMAIL_FORWARDING, emailAddressObject.getPkey(), destination});
    }

    @Override
    public Forwarding get(int pkey) throws SQLException, IOException {
        return (Forwarding)this.getUniqueRow(0, pkey);
    }

    public List<Forwarding> getEmailForwarding(Account account) throws SQLException, IOException {
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<Forwarding> matches = new ArrayList<Forwarding>(len);
        for (int c = 0; c < len; ++c) {
            Forwarding forward = (Forwarding)cached.get(c);
            if (!forward.getEmailAddress().getDomain().getPackage().getAccount_name().equals(account.getName())) continue;
            matches.add(forward);
        }
        return matches;
    }

    List<Forwarding> getEmailForwardings(Address ea) throws IOException, SQLException {
        return this.getIndexedRows(1, ea.getPkey());
    }

    List<Forwarding> getEnabledEmailForwardings(Address ea) throws SQLException, IOException {
        if (!ea.getDomain().getPackage().isDisabled()) {
            return this.getEmailForwardings(ea);
        }
        return Collections.emptyList();
    }

    Forwarding getEmailForwarding(Address ea, Email destination) throws IOException, SQLException {
        for (Forwarding forward : this.getEmailForwardings(ea)) {
            if (!forward.getDestination().equals((Object)destination)) continue;
            return forward;
        }
        return null;
    }

    public List<Forwarding> getEmailForwarding(Server ao) throws SQLException, IOException {
        int aoPkey = ao.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<Forwarding> matches = new ArrayList<Forwarding>(len);
        for (int c = 0; c < len; ++c) {
            Forwarding forward = (Forwarding)cached.get(c);
            if (forward.getEmailAddress().getDomain().getLinuxServer_host_id() != aoPkey) continue;
            matches.add(forward);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_FORWARDING;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_email_forwarding")) {
            if (Aosh.checkMinParamCount("add_email_forwarding", args, 3, (PrintWriter)err)) {
                if (args.length % 3 != 1) {
                    err.println("aosh: add_email_forwarding: must have multiple of three number of parameters");
                    err.flush();
                } else {
                    for (int c = 1; c < args.length; c += 3) {
                        String addr = args[c];
                        int pos = addr.indexOf(64);
                        if (pos == -1) {
                            err.print("aosh: add_email_forwarding: invalid email address: ");
                            err.println(addr);
                            err.flush();
                            continue;
                        }
                        out.println(this.connector.getSimpleClient().addEmailForwarding(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), args[c + 1], Aosh.parseEmail(args[c + 2], "to_address")));
                        out.flush();
                    }
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_email_forwarding")) {
            if (Aosh.checkParamCount("remove_email_forwarding", args, 3, (PrintWriter)err)) {
                String addr = args[1];
                int pos = addr.indexOf(64);
                if (pos == -1) {
                    err.print("aosh: remove_email_forwarding: invalid email address: ");
                    err.println(addr);
                    err.flush();
                } else {
                    this.connector.getSimpleClient().removeEmailForwarding(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "domain"), args[2], Aosh.parseEmail(args[3], "destination"));
                }
            }
            return true;
        }
        return false;
    }
}

