/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class InboxAddress
extends CachedObjectIntegerKey<InboxAddress>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_EMAIL_ADDRESS = 1;
    static final int COLUMN_LINUX_SERVER_ACCOUNT = 2;
    static final String COLUMN_EMAIL_ADDRESS_name = "email_address";
    static final String COLUMN_LINUX_SERVER_ACCOUNT_name = "linux_server_account";
    private int emailAddress;
    private int linuxServerAccount;
    private User.Name linuxAccount;

    @Deprecated
    public InboxAddress() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.emailAddress;
        }
        if (i == 2) {
            return this.linuxServerAccount;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getEmailAddress_id() {
        return this.emailAddress;
    }

    public Address getEmailAddress() throws SQLException, IOException {
        Address emailAddressObject = this.table.getConnector().getEmail().getAddress().get(this.emailAddress);
        if (emailAddressObject == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.emailAddress);
        }
        return emailAddressObject;
    }

    public int getLinuxServerAccount_id() {
        return this.linuxServerAccount;
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        UserServer lsa = this.table.getConnector().getLinux().getUserServer().get(this.linuxServerAccount);
        if (lsa == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.linuxServerAccount);
        }
        return lsa;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_ACC_ADDRESSES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.emailAddress = result.getInt(pos++);
            this.linuxServerAccount = result.getInt(pos++);
            this.linuxAccount = User.Name.valueOf(result.getString(pos++));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.emailAddress = in.readCompressedInt();
        this.linuxServerAccount = in.readCompressedInt();
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.LINUX_ACC_ADDRESSES, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getEmailAddress().toStringImpl() + "->" + this.getLinuxServerAccount().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.emailAddress);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeUTF(this.linuxAccount.toString());
        } else {
            out.writeCompressedInt(this.linuxServerAccount);
        }
    }
}

