/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.InboxAddress;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class InboxAddressTable
extends CachedTableIntegerKey<InboxAddress> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("email_address.domain.domain", true), new AoservTable.OrderBy("email_address.domain.ao_server.hostname", true), new AoservTable.OrderBy("email_address.address", true), new AoservTable.OrderBy("linux_server_account.username", true)};

    InboxAddressTable(AoservConnector connector) {
        super(connector, InboxAddress.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addLinuxAccAddress(Address emailAddressObject, UserServer lsa) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.LINUX_ACC_ADDRESSES, emailAddressObject.getPkey(), lsa.getPkey()});
    }

    @Override
    public InboxAddress get(int pkey) throws IOException, SQLException {
        return (InboxAddress)this.getUniqueRow(0, pkey);
    }

    public List<Address> getEmailAddresses(UserServer lsa) throws SQLException, IOException {
        List<InboxAddress> cached = this.getLinuxAccAddresses(lsa);
        int len = cached.size();
        ArrayList<Address> matches = new ArrayList<Address>(len);
        for (int c = 0; c < len; ++c) {
            InboxAddress acc = cached.get(c);
            matches.add(acc.getEmailAddress());
        }
        return matches;
    }

    public List<InboxAddress> getLinuxAccAddresses(UserServer lsa) throws IOException, SQLException {
        return this.getIndexedRows(2, lsa.getPkey());
    }

    public InboxAddress getLinuxAccAddress(Address address, UserServer lsa) throws IOException, SQLException {
        int address_id = address.getPkey();
        int lsaPkey = lsa.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            InboxAddress laa = (InboxAddress)cached.get(c);
            if (laa.getEmailAddress_id() != address_id || laa.getLinuxServerAccount_id() != lsaPkey) continue;
            return laa;
        }
        return null;
    }

    public List<InboxAddress> getLinuxAccAddresses(Server ao) throws IOException, SQLException {
        int aoPkey = ao.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<InboxAddress> matches = new ArrayList<InboxAddress>(len);
        for (int c = 0; c < len; ++c) {
            InboxAddress acc = (InboxAddress)cached.get(c);
            if (acc.getEmailAddress().getDomain().getLinuxServer_host_id() != aoPkey) continue;
            matches.add(acc);
        }
        return matches;
    }

    List<UserServer> getLinuxServerAccounts(Address address) throws IOException, SQLException {
        int address_id = address.getPkey();
        List cached = this.getRows();
        int len = cached.size();
        ArrayList<UserServer> matches = new ArrayList<UserServer>(len);
        for (int c = 0; c < len; ++c) {
            UserServer lsa;
            InboxAddress acc = (InboxAddress)cached.get(c);
            if (acc.getEmailAddress_id() != address_id || (lsa = acc.getLinuxServerAccount()) == null) continue;
            matches.add(lsa);
        }
        return matches;
    }

    List<InboxAddress> getLinuxAccAddresses(Address address) throws IOException, SQLException {
        return this.getIndexedRows(1, address.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.LINUX_ACC_ADDRESSES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_linux_acc_address")) {
            if (Aosh.checkParamCount("add_linux_acc_address", args, 3, (PrintWriter)err)) {
                String addr = args[1];
                int pos = addr.indexOf(64);
                if (pos == -1) {
                    err.print("aosh: add_linux_acc_address: invalid email address: ");
                    err.println(addr);
                    err.flush();
                } else {
                    out.println(this.connector.getSimpleClient().addLinuxAccAddress(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), args[2], Aosh.parseLinuxUserName(args[3], "username")));
                    out.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_linux_acc_address")) {
            if (Aosh.checkParamCount("remove_linux_acc_address", args, 3, (PrintWriter)err)) {
                String addr = args[1];
                int pos = addr.indexOf(64);
                if (pos == -1) {
                    err.print("aosh: remove_linux_acc_address: invalid email address: ");
                    err.println(addr);
                    err.flush();
                } else {
                    this.connector.getSimpleClient().removeLinuxAccAddress(addr.substring(0, pos), Aosh.parseDomainName(addr.substring(pos + 1), "address"), args[2], Aosh.parseLinuxUserName(args[3], "username"));
                }
            }
            return true;
        }
        return false;
    }
}

