/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservStreamable;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import java.io.IOException;
import java.sql.SQLException;

public final class InboxAttributes
implements AoservStreamable {
    private final AoservConnector connector;
    private final int linuxServerAccount;
    private long systemTime;
    private long fileSize;
    private long lastModified;

    public InboxAttributes(AoservConnector connector, UserServer lsa) {
        this.connector = connector;
        this.linuxServerAccount = lsa.getPkey();
    }

    public InboxAttributes(long fileSize, long lastModified) {
        this.connector = null;
        this.linuxServerAccount = -1;
        this.systemTime = System.currentTimeMillis();
        this.fileSize = fileSize;
        this.lastModified = lastModified;
    }

    public AoservConnector getAoservConnector() {
        return this.connector;
    }

    public UserServer getLinuxServerAccount() throws IOException, SQLException {
        return this.connector.getLinux().getUserServer().get(this.linuxServerAccount);
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    @Deprecated
    public void read(StreamableInput in, String protocolVersion) throws IOException {
        this.read(in, AoservProtocol.Version.getVersion(protocolVersion));
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.systemTime = in.readLong();
        this.fileSize = in.readLong();
        this.lastModified = in.readLong();
    }

    @Override
    @Deprecated
    public void write(StreamableOutput out, String protocolVersion) throws IOException {
        this.write(out, AoservProtocol.Version.getVersion(protocolVersion));
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeLong(this.systemTime);
        out.writeLong(this.fileSize);
        out.writeLong(this.lastModified);
    }
}

