/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.ListAddress;
import com.aoindustries.aoserv.client.email.MajordomoList;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;

public final class List
extends CachedObjectIntegerKey<List>
implements Removable,
Disablable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_LINUX_SERVER_ACCOUNT = 2;
    static final String COLUMN_LINUX_SERVER_ACCOUNT_name = "linux_server_account";
    static final String COLUMN_PATH_name = "path";
    public static final String LIST_DIRECTORY = "/etc/mail/lists";
    public static final int MAX_NAME_LENGTH = 64;
    private PosixPath path;
    private int linuxServerAccount;
    private int linuxserverGroup;
    private int disableLog;

    @Deprecated
    public List() {
    }

    public int addEmailAddress(Address address) throws IOException, SQLException {
        return this.table.getConnector().getEmail().getListAddress().addEmailListAddress(address, this);
    }

    @Override
    public boolean canDisable() {
        return this.disableLog == -1;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getLinuxServerGroup().getLinuxGroup().getPackage().isDisabled() && !this.getLinuxServerAccount().isDisabled();
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.EMAIL_LISTS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.EMAIL_LISTS, this.pkey});
    }

    public String getAddressList() throws IOException, SQLException {
        return this.table.getConnector().requestStringQuery(true, AoservProtocol.CommandId.GET_EMAIL_LIST_ADDRESS_LIST, this.pkey);
    }

    public int getAddressListCount() throws IOException, SQLException {
        String list = this.getAddressList();
        java.util.List lines = Strings.split((String)list, (char)'\n');
        int count = 0;
        for (String line : lines) {
            if (line.trim().length() <= 0) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.path;
            }
            case 2: {
                return this.linuxServerAccount;
            }
            case 3: {
                return this.linuxserverGroup;
            }
            case 4: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public java.util.List<Address> getEmailAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getListAddress().getEmailAddresses(this);
    }

    public java.util.List<ListAddress> getEmailListAddresses() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getListAddress().getEmailListAddresses(this);
    }

    public int getLinuxServerAccount_pkey() {
        return this.linuxServerAccount;
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        UserServer linuxServerAccountObject = this.table.getConnector().getLinux().getUserServer().get(this.linuxServerAccount);
        if (linuxServerAccountObject == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.linuxServerAccount);
        }
        return linuxServerAccountObject;
    }

    public int getLinuxServerGroup_pkey() {
        return this.linuxserverGroup;
    }

    public GroupServer getLinuxServerGroup() throws SQLException, IOException {
        GroupServer linuxServerGroupObject = this.table.getConnector().getLinux().getGroupServer().get(this.linuxserverGroup);
        if (linuxServerGroupObject == null) {
            throw new SQLException("Unable to find LinuxServerGroup: " + this.linuxserverGroup);
        }
        return linuxServerGroupObject;
    }

    public static PosixPath getListPath(String name, int osv) throws ValidationException {
        switch (osv) {
            case 67: {
                if (name.length() > 1) {
                    return PosixPath.valueOf("/etc/mail/lists/" + Character.toLowerCase(name.charAt(0)) + '/' + name);
                }
                String invalidPath = "/etc/mail/lists//";
                PosixPath.valueOf(invalidPath);
                throw new AssertionError((Object)(invalidPath + " is invalid and should have already thrown " + ValidationException.class.getName()));
            }
            case 70: {
                if (name.length() > 1) {
                    return PosixPath.valueOf("/etc/mail/lists/" + name);
                }
                String invalidPath = "/etc/mail/lists/";
                PosixPath.valueOf(invalidPath);
                throw new AssertionError((Object)(invalidPath + " is invalid and should have already thrown " + ValidationException.class.getName()));
            }
        }
        throw new AssertionError((Object)("Unexpected OperatingSystemVersion: " + osv));
    }

    public MajordomoList getMajordomoList() throws IOException, SQLException {
        return this.table.getConnector().getEmail().getMajordomoList().get(this.pkey);
    }

    public PosixPath getPath() {
        return this.path;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_LISTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.path = PosixPath.valueOf(result.getString(2));
            this.linuxServerAccount = result.getInt(3);
            this.linuxserverGroup = result.getInt(4);
            this.disableLog = result.getInt(5);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public static boolean isValidRegularPath(PosixPath path, int osv) {
        if (path == null) {
            return false;
        }
        String pathStr = path.toString();
        if (!pathStr.startsWith("/etc/mail/lists/")) {
            return false;
        }
        pathStr = pathStr.substring(LIST_DIRECTORY.length() + 1);
        switch (osv) {
            case 67: {
                if (pathStr.length() < 2) {
                    return false;
                }
                char firstChar = pathStr.charAt(0);
                if (pathStr.charAt(1) != '/') {
                    return false;
                }
                int len = (pathStr = pathStr.substring(2)).length();
                if (len < 1 || len > 64) {
                    return false;
                }
                for (int c = 0; c < len; ++c) {
                    char ch = pathStr.charAt(c);
                    if (c == 0) {
                        if (!(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                            return false;
                        }
                        if (Character.toLowerCase(ch) == firstChar) continue;
                        return false;
                    }
                    if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '.' || ch == '-' || ch == '_') continue;
                    return false;
                }
                return true;
            }
            case 70: {
                int len = pathStr.length();
                if (len < 1 || len > 64) {
                    return false;
                }
                for (int c = 0; c < len; ++c) {
                    char ch = pathStr.charAt(c);
                    if (!(c == 0 ? !(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') : !(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '.' || ch == '-' || ch == '_'))) continue;
                    return false;
                }
                return true;
            }
        }
        throw new AssertionError((Object)("Unexpected OperatingSystemVersion: " + osv));
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.path = PosixPath.valueOf(in.readUTF());
            this.linuxServerAccount = in.readCompressedInt();
            this.linuxserverGroup = in.readCompressedInt();
            this.disableLog = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public java.util.List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_LISTS, this.pkey});
    }

    public void setAddressList(String addresses) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_EMAIL_LIST_ADDRESS_LIST, this.pkey, addresses);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.path.toString());
        out.writeCompressedInt(this.linuxServerAccount);
        out.writeCompressedInt(this.linuxserverGroup);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeShort(0);
            out.writeShort(7);
        }
        out.writeCompressedInt(this.disableLog);
    }
}

