/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.email;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.email.Domain;
import com.aoindustries.aoserv.client.email.List;
import com.aoindustries.aoserv.client.email.MajordomoList;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class ListAddress
extends CachedObjectIntegerKey<ListAddress>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_EMAIL_ADDRESS = 1;
    static final int COLUMN_EMAIL_LIST = 2;
    static final String COLUMN_EMAIL_ADDRESS_name = "email_address";
    static final String COLUMN_EMAIL_LIST_name = "email_list";
    private int emailAddress;
    private int emailList;

    @Deprecated
    public ListAddress() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.emailAddress;
            }
            case 2: {
                return this.emailList;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getEmailAddress_pkey() {
        return this.emailAddress;
    }

    public Address getEmailAddress() throws SQLException, IOException {
        Address emailAddressObject = this.table.getConnector().getEmail().getAddress().get(this.emailAddress);
        if (emailAddressObject == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.emailAddress);
        }
        return emailAddressObject;
    }

    public int getEmailList_pkey() {
        return this.emailList;
    }

    public List getEmailList() throws SQLException, IOException {
        List emailListObject = this.table.getConnector().getEmail().getList().get(this.emailList);
        if (emailListObject == null) {
            throw new SQLException("Unable to find EmailList: " + this.emailList);
        }
        return emailListObject;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.EMAIL_LIST_ADDRESSES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.emailAddress = result.getInt(2);
        this.emailList = result.getInt(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.emailAddress = in.readCompressedInt();
        this.emailList = in.readCompressedInt();
    }

    public java.util.List<CannotRemoveReason<MajordomoList>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList<CannotRemoveReason<MajordomoList>> reasons = new ArrayList<CannotRemoveReason<MajordomoList>>();
        for (MajordomoList ml : this.table.getConnector().getEmail().getMajordomoList().getRows()) {
            if (ml.getListListAddress().getPkey() != this.pkey) continue;
            Domain ed = ml.getMajordomoServer().getDomain();
            reasons.add(new CannotRemoveReason<MajordomoList>("Used by Majordomo list " + ml.getName() + '@' + ed.getDomain() + " on " + ed.getLinuxServer().getHostname(), ml));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.EMAIL_LIST_ADDRESSES, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getEmailAddress().toStringImpl() + "->" + this.getEmailList().getPath();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.emailAddress);
        out.writeCompressedInt(this.emailList);
    }
}

